import matplotlib.pyplot as plt
import numpy as np
from shiny import App, render, ui
import json
import pandas as pd

data_frame = pd.read_csv('data/sonde.csv')

app_ui = ui.page_fluid(
    ui.head_content(
        ui.tags.style(
            """
        /* Smaller font for preformatted text */
        pre, table.table {
          font-size: smaller;
        }

        pre, table.table {
            font-size: smaller;
        }
        """
        )
    ),
    ui.row(ui.column(
            4,
            ui.panel_well(
                ui.input_select("mission_days","Début du rendu (jour de mission)",data_frame['Mission Day'].values.tolist())
            ),
        ),
        ui.column(
            8,
            ui.output_plot("plot_probe",click=True),# , dblclick=True, hover=True, brush=True),
        ),
    ),
ui.row(
        ui.column(3, ui.output_code("click_me")),
    ),
)


def server(input, output, session):
    @render.plot(alt="The plot")
    def plot_probe():
        global data_frame
        fig, ax = plt.subplots()
        plt.title("Sonde")
        # injection de la série de données (ordonnées)
        ax.plot(data_frame[data_frame['Mission Day'] > int(input.mission_days())]['Max Temp'])
        return fig

    @render.code()
    def click_me():
        return "click:\n" + json.dumps(input.plot_probe_click(), indent=2)


app = App(app_ui, server)#, debug=True)
