"""
programme principal pour afficher les graphes d'un fichier de sonde
"""
from argparse import ArgumentParser
from klasses.klass_sonde import Sonde

if __name__ == "__main__":
    # programme principal, utilisation de l'objet sonde pour
    # abstraire le fichier CSV
    # récupération de l'emplacement du fichier via appel au script,
    # et début du jour de mission en option
    # python main_sonde.py emplacement_fichier --start_day=100
    # définition d'un parser d'arguements
    argument_parser = ArgumentParser()
    # définition de l'argument emplacement (obligatoire)
    argument_parser.add_argument("path",
                                 help="Emplacement du fichier sonde")
    # définition de l'argument début d'affichage pour le jour
    # de la mission; 0 par défaut
    argument_parser.add_argument(
        "--start_day",
        help="A partir de quel jour de la mission ?",
        type=int, default=0
    )
    # récupération des arguments effectivement passés
    args = argument_parser.parse_args()
    # création de notre objet
    sonde = Sonde(args.path)
    # lancement des méthodes !
    sonde.nettoyer()
    sonde.afficher_graphe(debut=args.start_day)
