"""
Module principal pour une application shiny
"""
#imports nécessaires
from shiny import App, render, ui
from pandas import read_csv
from os.path import join
from matplotlib import pyplot as plt


#création du data frame
data_frame = read_csv(join('data','sonde.csv'))
#création de l'interface utilisateur: une page
#enchainement de lignes et de colonnes
#les lignes sont des blocs de 12
interface_utilisateur = ui.page_fluid(
    ui.row(ui.column(
        4,
        ui.input_select("jour","A partir de quel jour ?",data_frame['Mission Day'])
    ),
    ui.column(
        8,
        ui.output_plot("affichage_sonde")
    )
    )
)
#création du backend, le serveur et les
#traitements associés
def serveur(input, output,session):
    @render.plot()
    def affichage_sonde():
        """
        méthode de rendu type plot (matplotlib ici) du rendu de sonde
        :return:
        """
        #création de la figure
        fig, ax = plt.subplots(ncols=2)
        #création du titre
        plt.title("Mes température")
        #récupération du nombre de jour depuis
        #la liste déroulante
        jour_choisi = int(input.jour())#conversion en integer ! Attention !
        #filtrage des données, uniquement celles qui sont au delà
        #du jour de mission choisi
        data_frame_filtre = data_frame[data_frame['Mission Day'] > jour_choisi]
        #affichage du tracé pour la série max temp
        ax[0].plot(data_frame_filtre['Mission Day'], data_frame_filtre['Max Temp'])
        #affichage du tracé pour la série min temp
        ax[1].plot(data_frame_filtre['Mission Day'], data_frame_filtre['Min Temp'])
        #nous renvoyons la figure !
        return fig

#par défaut, une variable app est attendue dans
#le module principal
#lancement en console: shiny run main_shiny.py
app = App(interface_utilisateur, serveur)