"""
Module principal pour le jeu du pendu
"""
from configparser import ConfigParser
from argparse import ArgumentParser
from klasses.klass_pendu import Pendu
from tests_logs import logger

if __name__ == "__main__":
    #utilisation de notre outil personnalisé de log !
    logger.info("Démarrage du programme")
    # permettre le passage du nombre d'erreurs par argument...
    # et non en dur dans le code !
    parser = ArgumentParser()
    # argument optionnel, par défaut: 11
    parser.add_argument(
        "--max_erreur",
        help="Permet d'indiquer le nombre d'erreurs max pour le jeu",
        type=int,
        default=11,
    )
    # récupération des arguments effectivement passés
    reconcialation = parser.parse_args()
    # approche alternative: par fichier de configuration !
    # utilisation d'un objet pour gérer les fichiers
    # de configuraiton
    config = ConfigParser()
    # lecture du fichier
    config.read("config.ini")
    # récupération du paramètre...TODO: try ?
    jeu = Pendu(int(config["PENDU"]["max_erreurs"]))
    # test de la méthode __str__ par défaut
    print(jeu)
    # test du hack ;-)
    jeu + 6
    # on peut maintenant jouer !
    jeu.lancer_partie()
