"""
Module de définition de la class Sonde
"""
#première étape: les imports
from os.path import isfile
from csv import reader, writer
from pandas import read_csv
from matplotlib import pyplot as plt
class Sonde:
    """
    Définition de classe Sonde qui permet une abstraction sur
    les fichiers CSV de sonde (A06174testR.csv dans le dossier data)
    """
    #paramètre de classe
    #emplacement du fichier des données Sonde
    emplacement:str = ''
    #Etat du fichier
    __nettoye:bool = False
    def __init__(self, emplacement_fichier:str)->None:
        """
        Construction de la sonde. Le fichier doit existant.
        Le cas contraire, l'objet de fonctionnera pas
        :param emplacement_fichier: type str, l'emplacement du fichier CSV
        """
        #contrôle: est ce un fichier ?
        if isfile(emplacement_fichier):
            #oui, nous stockons l'information.
            self.emplacement = emplacement_fichier
        else:
            #l'emplacement reste vide. Attention, un test à effectuer sur les autres méthodes !
            #Alternative: on peut lever une exception, mais elle doit être gérée par le programme appelant ;-)
            #raise IOError(f'Fichier inconnu {emplacement_fichier}')
            #un print pour prévenir... TODO: passage en log
            print(f'Fichier inconnu {emplacement_fichier}')

    def nettoyer(self)->None:
        """
        Méthode pour nettoyer le fichier de sonde.
        Le fichier est ecrasé directement !
        :return: None, agit directement
        """
        #TODO: pertinence du try ? Dans une logique de boucle, le try peut être plus pertinent !
        if self.emplacement:
            #le fichier est bien nettoyé car la propriété n'est pas vide
            #stockage en mémoire des lignes; nous pourrions prévoir un fichier temporaire pour R/W en parallèle
            lignes = []
            #reférence directe vers la méthode append (raccourci plus performant)
            append_lignes = lignes.append
            #ouverture du fichier CSV nettoyé en lecture; préciser l'encodage est une garantie !
            with open(self.emplacement, 'r', encoding='utf-8') as fichier_ouvert:
                #construction du parseur CSV, avec les caractéristiques surchargées
                parser_csv = reader(fichier_ouvert, delimiter=',', lineterminator='\n')
                #pour chaque ligne
                for ligne in parser_csv:
                    #pour chaque ligne avec une taille de 7 colonnes
                    if len(ligne)==7:
                        #j'ajoute/stocke cette ligne en mémoire
                        append_lignes(ligne)
            self.__ecrire_fichier_propre(lignes)

    def __ecrire_fichier_propre(self, lignes:list):
        """
        ecrire le fichier; fractionner pour faciliter les tests unitaires
        :param lignes: type liste, les lignes à écrire dans le fichier
        :return:  None, pas de controle de sortie
        """
        #j'ouvre maintenant en écriture le fichier; là encore, ne pas hésiter à préciser l'encodage
        try:
            with open(self.emplacement, 'w', encoding='utf-8') as fichier_ecrire:
                #création d'un outil pour écrire le csv
                ecrivain_csv = writer(fichier_ecrire, delimiter=',', lineterminator='\n')
                ecrivain_csv.writerows(lignes)
            self.__nettoye = True
        except IOError as erreur:
            #TODO: mettre en place des logs
            print(f'Erreur lors du nettoyage: {erreur}')

    def afficher_graphe(self, debut=0):
        """
        afficher le rendu sous matplolib
        :param debut: type int, rendu à partir de ce jour de mission !
        Par défaut: 0, donc, début de la mission
        :return:
        """
        #le fichier est nettoyé ?
        if self.__nettoye:
            #oui, nous pouvons donc utiliser pandas
            #chargement du fichier dans un dataframe
            df = read_csv(self.emplacement)
            #filtrage
            df = df[df['Mission Day']>debut]
            #Création de la figure pour le rendu des tracés
            fig, ax = plt.subplots(nrows=2)
            #axe 1: la température max
            ax[0].plot(df['Mission Day'],df['Max Temp'])
            #un second tracé
            ax[0].plot(df['Mission Day'], df['Min Temp'])
            ax[0].set_title('Temp max/min')
            #axe 2: la températeur min
            ax[1].plot(df['Mission Day'],df['Min Temp'])
            ax[1].set_title('Temp Min')
            #ajustement/rendu de la figure
            plt.tight_layout()  # Ajuste l'espace pour éviter les chevauchements
            plt.xlabel('Jour de mission')
            plt.show()




