"""
module de définition des fonctions pour gérer le téléchargement d'url YT
"""
#imports nécessaires
from pytube import YouTube

def telecharger_url(url:str, dossier_cible:str, backlog:callable):
        """
        Méthode telecharger une vidéos proposée 
        En entrée: 
        - url: url de la vidéo
        - dossier_cible: type str, le dossier cible
        - backlog: fonction pour envoyer des messages à l'IHM
        Sortie:
        - Rien 
        """
        backlog(f"Début téléchargement url {url}")
        try:
            yt = YouTube(url)
            backlog(f"Vidéo trouvée: {yt.title}. Lancement téléchargement")
            yt.streams.filter(file_extension="mp4").get_highest_resolution().download(output_path=dossier_cible)
            backlog(f"Vidéo téléchargée.")
        except:
            backlog(f"Erreur: impossible de télécharger le vidéo !")