"""
Module de définition du juste prix !
"""
#imports nécessaires au fonctionnement
import tkinter
from tkinter.filedialog import askdirectory, askopenfilename
from csv import reader
from outils.yt_tools import telecharger_url
class YTDownload:
    """
    Interface graphique pour permettre le téléchargement de vidéo YT
    """
    def __init__(self):
        """
        Constructeur: mise en place de l'interface graphique
        """
        self.__dl_dossier = ''
        fenetre_principale = tkinter.Tk()
        fenetre_principale.title("Youtube Downloader")
        fenetre_principale.geometry("720x540")
        fenetre_principale.minsize(720,540)

        frame_haut = tkinter.Frame(fenetre_principale)
        frame_haut.grid(column=0,row=0,sticky='nesw')
        #zone pour les boutons, haut à gauche
        f_bouttons = tkinter.Frame(frame_haut)
        f_bouttons.grid(column=0,row=0)                       
        tkinter.Button(f_bouttons,text='1. Dossier DL ?', command=self.__choix_dossier).grid(column=0,row=0)
        tkinter.Button(f_bouttons,text='2. Fichier CSV ?', command=self.__charger_csv).grid(column=0,row=1)
        tkinter.Button(f_bouttons,text='3. Télécharger', command=self.__upload).grid(column=0,row=2)

        #la liste des vidéos
        self.__video = tkinter.Text(frame_haut)
        self.__video.grid(column=1,row=0,sticky='nesw') 

        #la log
        self.__log = tkinter.Text(fenetre_principale)
        self.__log.grid(column=0,row=1,sticky='nesw')
        fenetre_principale.mainloop()

    def __ecrire_log(self, message):
        """
        Méthode écrire dans la log
        En entrée: 
        - Message
        Sortie:
        - Rien 
        """
        #faciliter l'écriture des logs par l'appel d'une méthode
        self.__log.insert(tkinter.END,f'{message}\n')

    def __charger_csv(self):
        """
        Méthode pour choisir choisir un CSV et le charger dans la liste
        En entrée: 
        - Rien
        Sortie:
        - Rien 
        """
        #choix du fichier CSV, avec un filtre ;-)
        fichier_csv = askopenfilename(filetypes=[("CSV files", ".csv")])
        #ouverture du fichier
        with open(fichier_csv,'r',encoding='utf-8') as fichier_csv:
            #parcours avec le parseur csv
            for num_ligne, ligne in enumerate(reader(fichier_csv,delimiter=';')):
                try:
                    #chaque ligne doit avoir 2 colonnes: l'url et le nom
                    vurl, vnom = ligne
                    self.__video.insert(tkinter.END,f"{vurl}\n")
                    #loguer les actions
                    self.__ecrire_log(f"Ajout {vnom}, située {vurl}")
                except:
                    #la ligne n'est pas bien formatée !
                    self.__ecrire_log(f"CSV: ligne {num_ligne} ko.")


    def __upload(self):
        """
        Méthode lancer le téléchargement de la liste
        En entrée: 
        - Rien
        Sortie:
        - Rien 
        """
        #quelques contrôles
        if not self.__dl_dossier:
            self.__ecrire_log("Il faut choisir le dossier de téléchargement !")
        #récupération de la liste des urls en chaine de caractères
        liste_video_contenu = self.__video.get(0., tkinter.END)
        #passage en liste via un split
        liste_url = [url.strip() for url in liste_video_contenu.split('\n') if url.strip()]
        if not liste_url:
            self.__ecrire_log("Aucun élément dans la liste des urls !")
        for url in liste_url:
            #TODO: passer en thread pour éviter l'effet de freeze !
            telecharger_url(url,self.__dl_dossier, self.__ecrire_log)
        self.__ecrire_log("Fin téléchargement. Nettoyage liste")
        self.__video.delete(0., tkinter.END)

    def __choix_dossier(self):
        """
        Méthode pour choisir le dossier de DL
        En entrée: 
        - Rien
        Sortie:
        - Rien 
        """
        self.__dl_dossier = askdirectory()
        self.__ecrire_log(f'Dossier de téléchargement choisi:{self.__dl_dossier}')


