"""
Module de définition du jeu chifoumi !
"""
#imports nécessaires au fonctionnement
from random import choice

choix_possible = ('pierre', 'feuille', 'ciseau')

class Chifoumi:
    """
    gestion d'une partie de chifoumi
    """
    def __init__(self, score_gagnant:int=2) -> None:
        """
        Méthode pour lancer une partie
        En entrée: 
        - score_gagnant, type int: le nombre tour gagné pour gagner la partie
        Sortie:
        - Rien 
        """
        #stockage des informations nécessaires au 
        #fonctionnement
        self.__score_player = 0
        self.__score_ordi = 0
        self.__score_gagnant = score_gagnant

    def __gerer_saisie(self):
        """
        Méthode gérer la saisie utilisateur
        En entrée: 
        - Rien
        Sortie:
        - La saisie 
        """
        global choix_possible
        #saisie vide pour commencer
        saisie = ''
        #tant que la saisie n'est pas bonne
        while not saisie:
            try:
                #je récupère la saisie de l'utilisateur
                retour = input(f"Que choisissez vous ? {','.join(choix_possible)}: ").lower()
                #création d'une exception si la saisi n'existe pas (VS mettre un if)
                choix_possible.index(retour)
                #si pas d'exception, on affecte la saisie
                saisie = retour
            except:
                #petite aide à la saisie pour notre utilisateur
                print("Merci de saisie l'un des choix")
        #tout est ok, on renvoie la saisie
        return saisie

    def __afficher_partie(self):
        """
        Méthode pour afficher une partie via print
        En entrée: 
        - Rien
        Sortie:
        - Rien 
        """
        #simple print pour afficher à tout moment l'état de la partie
        print(f"""Etat de la partie:
Joueur: {self.__score_player} points
Ordi: {self.__score_ordi} points
Partie gagnée: {self.__score_gagnant}
""")
    
    def lancer_partie(self):
        """
        Méthode pour lancer une partie
        En entrée: 
        - Rien
        Sortie:
        - Rien 
        """
        #mise en place des variables de fonctionnement
        global choix_possible
        player_gagnant = False
        ordi_gagnant = False
        #boucle pour jouer tant qu'il n'y a pas de gagnant
        while not player_gagnant and not ordi_gagnant:
            #on récupère le choix de l'utilisateur
            choix_player = self.__gerer_saisie()
            #celui de l'ordi
            choix_ordi = choice(choix_possible)
            #affichage des choix
            print(f"joueur: {choix_player} VS ordi: {choix_ordi}" )
            #premier cas le plus simple
            if choix_player==choix_ordi:
                #on ne fait rien !
                print("Match nul. ")
            #cas des victoires du joueur:
            elif choix_player=='ciseau' and choix_ordi=='feuille' or \
                 choix_player=='feuille' and choix_ordi=='pierre' or \
                 choix_player=='pierre' and choix_ordi=='ciseau':   
                #joueur gagne
                self.__score_player +=1
                print("Joueur gagne")
            else:
                #l'ordi a forcement gagné !     
                self.__score_ordi += 1
                print("Ordi gagne")
            #un affichage pour l'état des lieux
            self.__afficher_partie()
            #on rafraichit les variables de sortie
            player_gagnant = self.__score_gagnant == self.__score_player
            ordi_gagnant = self.__score_gagnant == self.__score_ordi
        #nous sommes sortis de la boucle: qui a gagné ?
        if player_gagnant:
            print("Joueur gagne !")
        else:
            print("Ordi gagne ! ")

if __name__ == "__main__":
    #programme principal
    partie = 'oui'
    #on boucle tant que l'on veut jouer !
    while partie =='oui':
        #création d'une nouvelle partie
        jeu = Chifoumi()
        #lancement
        jeu.lancer_partie()
        #encore une partie ?
        partie = input('Nouvelle partie ? oui, non: ')
