__author__ = 'nicolasperrier'

"""
Simple demo of a horizontal bar chart.
"""
import matplotlib.pyplot as plt; plt.rcdefaults()
import numpy as np
import matplotlib.pyplot as plt
import cStringIO
from tkinter import Canvas,Tk,StringVar, Entry, Button
from PIL import Image,ImageTk



class MonAppli:
    def __init__(self,window):
        self.window = window
        self.data = StringVar()
        self.ent = Entry(window,textvariable=self.data)
        self.ent.pack()
        self.butt = Button(window,text='Show',command=self.faireCanva)
        self.butt.pack()
        self.photo = None
        self.canvas = Canvas(window, width = 800, height = 600)
        self.canvas.pack()


    def faireCanva(self):
        # Example data
        self.canvas.delete('all')
        people = ('Tom', 'Dick', 'Harry', 'Slim', 'Jim')
        y_pos = np.arange(len(people))
        performance = int(self.data.get()) + 10 * np.random.rand(len(people))
        error = np.random.rand(len(people))
        plt.barh(y_pos, performance, xerr=error, align='center', alpha=0.4)
        plt.yticks(y_pos, people)
        plt.xlabel('Performance')
        plt.title('How fast do you want to go today?')

        img = cStringIO.StringIO()

        plt.savefig(img,format='png')
        img.seek(0)
        image = Image.open(img)
        self.photo = ImageTk.PhotoImage(image)
        self.canvas.create_image(400,300, image=self.photo)
        self.canvas.pack()

if __name__=='__main__':
    root = Tk()
    MonAppli(root)
    root.mainloop()



