# -*- coding: utf-8 -*-

from string import ascii_lowercase
import unicodedata

if __name__=='__main__':
    #exercice : sortir la liste des nombres impairs
    liste_nombres = [4, 8, 5, 36, 78, 0, -5, 3, -10]
    liste_impairs = []
    for elem in liste_nombres:#parcourir tous les éléments de la liste
        #pour chaque élément, je fais le test
        if elem % 2 != 0:
            #ok, je peux l'ajouter
            liste_impairs.append(elem)
    #j'affiche en console la liste résultat
    print(liste_impairs)

    #exercice : sortir la liste des nombres impairs (par liste de comprehension)
    print([elem for elem in liste_nombres if elem %2 != 0])



    #exercice : afficher toutes les tables de multiplication
    #je constitue une liste d'entiers de 0 à 10
    valeurs = range(0,11)
    #pour chaque table
    for table in valeurs:
        #j'affiche le début d'une table
        print('Table de {}:'.format(table))
        #pour chaque opération de la table
        for num in valeurs:
            #j'affiche le resultat
            print('{} * {} = {}'.format(table, num, table*num))


    #exercice : afficher les phrases qui sont des hétérogrammes: 1 lettre présente au max 1 fois
    phrases = ['Lampez un fort whisky',
             'The quick brown fox jumps over the lazy dog',
             "Plombez vingt fuyards",
             "The big dwarf only jumps",
             "Allons enfants de la patrie",
             "Tu l'as trop ecrase cesar ton port salut"
             ]
    print("Les hétérogrammes : ")
    #pour chaque phrase
    for phrase in phrases:
        #par défaut, je considère que la phrase est bonne
        est_heterogramme = True
        #traitement pour avoir uniquement des minuscules
        phrase_mini = phrase.lower()
        #pour chaque lettre, je vérifie que le cas est correct
        for lettre in ascii_lowercase:
            #je fais le test
            if phrase_mini.count(lettre) > 1:
                #ceci est un cas d'exclusion, je mets à faux mon "drapeau" et je quitte la boucle
                est_heterogramme = False
                break
        #selon le traitement, j'affiche ou non la phrase
        if est_heterogramme:
            print(phrase)


    #exercice : afficher les phrases qui sont des pangrammes (toutes les lettres de l'alphabet (au moins 1 fois))
    phrases = ['Portez ce vieux whisky au juge blond qui fume',
             'The quick brown fox jumps over the lazy dog',
             "Voix ambiguë d'un coeur qui au zéphyr préfère les jattes de kiwis",
             "Vif juge, trempez ce blond whisky aqueux",
             "Fripon, mixez l'abject whisky qui vidange",
             "Prouvez, juge, que le fameux sandwich au yak tue",
             "Buvez de ce bourbon que le patron juge fameux",
             "Voyez le brick énorme que j'examine près du wharf"
             ]
    print("Les pangrammes : ")
    #pour chaque phrase
    for phrase in phrases:
        #traitement uniquement avec les minuscules
        phrase_nettoyee = phrase.lower()
        #nettoyer les accents
        phrase_nettoyee = unicodedata.normalize('NFKD', phrase_nettoyee.decode('utf-8')).encode('UTF-8', 'ignore')
        #on part du principe que la phrase est bonne
        est_pangramme = True
        #pour toutes les lettres de l'alphabet
        for lettre in ascii_lowercase:
            if phrase_nettoyee.count(lettre)==0:
                #j'ai un cas d'exclusion... sortie de boucle et mise à faux
                #   if not phrase_nettoye.count(lettre):
                est_pangramme = False
                break
        #selon mon traitement, j'affiche la phrase ou non
        if est_pangramme:
            print(phrase)

    # exercice : dire quels sont les palindromes dans la liste de mots
    mots = ['radar',
            'kayak',
            'voiture',
            "Ressasser",
            "1234+8765=9999=5678+4321",
            ]
    # par la plus longue approche en nombre de lignes de code
    resultats = []
    for mot in mots:
        mot_envers = []
        for lettre in mot[::-1]:
            mot_envers.append(lettre)
        mot_envers = ''.join(mot_envers)
        if mot == mot_envers:
            resultats.append(mot)
    print(resultats)

    # par la manipulation des sequences
    resultats = []
    for mot in mots:
        if mot.lower() == mot[::-1].lower():
            resultats.append(mot)
    print(resultats)

    # par le reverse
    resultats = []
    for mot in mots:
        mot_envers = list(mot)
        mot_envers.reverse()
        mot_envers = ''.join(mot_envers)
        if mot_envers.lower() == mot.lower():
            resultats.append(mot)
    print(resultats)


    #exercice : trier les planetes par la taille de leur rayon
    def donner_rayon(donnees_planete):
        """
        permet de renvoyer le rayon
        :param donnees_planete: type dictionnaire
        :return: int, le rayon
        """
        rayon = donnees_planete.get('rayon',0)
        return rayon



    Venus = {'rayon' : 6051, 'nom':'Venus'}
    Mercure = {'rayon' : 2439,'nom' : 'Mercure'}
    Terre = {'rayon' : 6378, 'nom':'Terre'}
    Pluton = {'nom':'Pluton'}
    planetes = [Venus, Mercure, Terre,Pluton]
    planetes.sort()
    #on constate que le tri n'est pas bon...
    print(planetes)
    #on teste notre fonction de récupération du rayon
    rayon_trouve = donner_rayon(Venus)
    print(rayon_trouve)
    #on fait de nouveau le tri avec la function de récupération des données de tri
    planetes.sort(key=donner_rayon)
    #le tri est ok !
    print(planetes)
    #on peut aussi définir une fonction à la volée, sans la nommer...
    planetes.sort(key=lambda donnees_planete:donnees_planete.get('rayon',0))
