import csv
import datetime
from timeit import itertools

#ouvrir un fichier CSV en lecture, pour extraire les donnees et entete de colonnes: moyenne de chacune des colonnes ?
#ecrire un nouveau CSV avec Date en format anglophone, valeur en entiers
#with open('jeux_de_tests/A06174testR.csv') as csvfile:

if __name__=='__main__':
    # Option: passage d'argument ?
    # parser = argparse.ArgumentParser()
    # parser.add_argument('--fichier', help="Chemin vers le fichier CSV")
    #
    # arguments = parser.parse_args()
    # chemin = arguments.fichier
    #Approche read/write sans traitement dictionnaire
    with open('jeux_de_tests/A06174testR.csv','r') as fichierLecture:
        with open('jeux_de_tests/sortie.csv','w') as fichierEcriture:
            lecteurCSV = csv.reader(fichierLecture, delimiter=',')
            ecritureCSV = csv.writer(fichierEcriture,lineterminator='\n')
            header = []
            for ligne in lecteurCSV:
                if len(ligne)==7:
                    if not ligne[0].isdigit():
                        header = ligne
                        ecritureCSV.writerow(header)
                        continue
                    elemEnFloat = map(float,ligne[2:])
                    elemEnInt = map(int,elemEnFloat)
                    date_objet = datetime.datetime.strptime(ligne[1],'%d/%m/%Y')
                    #date_objet.strftime('%')
                    jour,mois, annee = ligne[1].split('/')
                    bonneDate = '%s/%s/%s' % (annee,mois,jour)
                    nxLigne = [ligne[0],bonneDate]
                    nxLigne.extend(elemEnInt)
                    ecritureCSV.writerow(nxLigne)

    def transformerDictionnaire(keys, values):
        """
        faire le passage d'une liste de valeurs vers un dictionnaire
        :param keys: cles du dictionnaire
        :param values: valeur dans l'ordre des cles
        :return:
        """
        resultat = {}
        for i,key in enumerate(keys):
            resultat[key] = values[i]
        return resultat

    with open('jeux_de_tests/A06174testR.csv','r') as fichierLecture:
        with open('jeux_de_tests/sortie.csv','w') as fichierEcriture:
            lecteurCSV = csv.reader(fichierLecture, delimiter=',')
            header = []
            for ligne in lecteurCSV:
                if len(ligne)==7:
                    if not ligne[0].isdigit():
                        header = ligne
                        break
            fichierLecture.seek(0)
            ecritureCSV = csv.DictWriter(fichierEcriture,lineterminator='\n',fieldnames=header)
            ecritureCSV.writeheader()
            for ligne in lecteurCSV:
                if len(ligne)==7:
                    if not ligne[0].isdigit():
                        continue
                    elemEnFloat = map(float,ligne[2:])
                    elemEnInt = map(int,elemEnFloat)
                    jour,mois, annee = ligne[1].split('/')
                    bonneDate = '%s/%s/%s' % (annee,mois,jour)
                    nxLigne = [ligne[0],bonneDate]
                    nxLigne.extend(elemEnInt)
                    ecritureCSV.writerow(transformerDictionnaire(header,nxLigne))
