#coding:utf-8
from bs4 import BeautifulSoup

#objectif: parcourir/parser un fichier au format XML et :
#- changer le numero avec un prefix 0-
#- récrire le fichier avec le changement
if __name__=='__main__':
    #variable stockant la lecture du fichier
    contenu_fichier = ''
    #leture fichier
    with open('jeux_de_tests/cinna.ala','r') as mon_fichier:
        contenu_fichier = mon_fichier.read()
    #le contenu est il vide ou non ?
    if contenu_fichier:
        #nous "parsons" le fichier grace à beautifulsoup
        soup = BeautifulSoup(contenu_fichier,"html.parser")
        #je  parcours tous les tags "alerte"
        for tag in soup.find_all('alerte'):
            #je recupere le "sous tag" numero
            numero = tag.find('numero')
            #je recupere la valeur, et je la change
            numero.string = u'0-{}'.format(numero.string)
        #j'écris dans un nouveau fichier (attention, il faut encoder)
        with open('jeux_de_tests/cinna.new.ala','w') as fichier_ecriture:
            fichier_ecriture.write(soup.prettify(encoding='utf-8'))

