#!/usr/bin/python
# -*- coding: utf8 -*-
from string import punctuation
import functools
NO_PUNCT = str.maketrans(punctuation, ' ' * len(punctuation))

def clean_line(line):
    """Nettoie la phrase, et renvoie son 'Poids'"""
    line = line.translate(NO_PUNCT)
    cleaned_line = []
    for word in line.split():
        word = word.strip()
        if len(word) < 2:
            continue
        cleaned_line.append(word)
    numwords = len(cleaned_line)
    return numwords, ' '.join(cleaned_line)

def cmp_lines(line1, line2):
    """Compare les poids des phrases.

    En cas d'égalité, l'ordre alphanumérique.
    """
    same_size = (line1[0] > line2[0]) - (line1[0] < line2[0])
    if same_size == 0:
        return (line1[1] > line2[1]) - (line1[1] < line2[1])
    return same_size

def print_sorted_text(text):
    """ renvoie un tri en fonction du nombre de mots """
    print('Résultat:')
    for numwords, line in sorted(map(clean_line, text), key=functools.cmp_to_key(cmp_lines)):
        print('%s (%d)' % (line, numwords))

def get_text():
    print('Saisissez des phrases (une ligne vide pour terminer): ')
    text = []
    while True:
        line = input()
        if line == '':
            break
        text.append(line)
    return text

if __name__ == '__main__':
    print_sorted_text(get_text())

