"""
module proposant une classe César pour coder/décoder un texte; module permet d'appliquer cela au dossier passé en
argument via le nom "--chemin"
"""
from argparse import ArgumentParser
from os import listdir
from os.path import isdir, isfile, join
from string import ascii_letters
from os import walk


class Cesar:
    """
    Classe de décodage/codage d'un texte façon césar
    """
    def __init__(self, texte:str)->None:
        """
        stocker le texte à transformer via le constructeur
        :param texte:
        """
        self.texte = texte

    def transformer_cesar(self,translation:int)->str:
        """
        renvoyer le texte translaté
        :param translation: translation à appliquer pour retrouver les  nouvelles positions
        :return: texte décodé/codé
        """
        #la chaine de sortie
        texte_code = ''

        #pour chaque lettre de mon texte
        for lettre in self.texte:
            #position de la lettre ?
            position = ascii_letters.find(lettre)
            if position == -1:
                #lettre non reconnue dans l'alphabet... on remet en l'état
                texte_code = texte_code + lettre
            else:
                #lettre connue ! Quelle nouvelle position ?
                nouvelle_position = (position + translation) % len(ascii_letters)
                #nouvelle lettre ?
                nouvelle_lettre = ascii_letters[nouvelle_position]
                #on agglomère la nouvelle lettre
                texte_code = texte_code + nouvelle_lettre
        #renvoyer le texte codé/décodé
        return texte_code


if __name__ == '__main__':
    #utilisation de la librairie pour passer un argument: le chemin du dossier à scanner
    parser = ArgumentParser()
    parser.add_argument("--chemin", help="Permet d'indiquer le chemin du dossier à parcourir")
    arguments = parser.parse_args()
    if not arguments.chemin or not isdir(arguments.chemin):
        print("Erreur: {} n'est pas un dossier !".format(arguments.chemin))
    else:
        #pour tous les éléments du dossier
        for dossier_racine, liste_dossiers, liste_fichiers in walk(arguments.chemin):
            #pour tous les fichiers de chaque dossier
            for fichier in liste_fichiers:
                chemin_fichier = join(dossier_racine,fichier)
                #pour uniquement les fichiers txt portant dans leur nom "texte_code"
                if isfile(chemin_fichier) and 'texte_code' in fichier:
                    #ouverture et lecture du contenu
                    with open(chemin_fichier,'r') as fichier_lecture:
                        contenu = fichier_lecture.read()
                    #construction de la machine Cesar
                    machine_cesar = Cesar(contenu)
                    #transformation
                    contenu_decode = machine_cesar.transformer_cesar(-13)
                    #écriture du fichier ainsi obtenu
                    nom_fichier_decode = join(arguments.chemin,fichier+'.decode.txt')
                    with open(nom_fichier_decode,'w') as fichier_ecriture:
                        fichier_ecriture.write(contenu_decode)
