# -*- coding: utf-8 -*-
import pdb

import string
from string import ascii_lowercase

if __name__ == "__main__":
    # exercice : sortir la liste des nombres impairs
    liste = [4, 8, 5, 36, 78, 0, -5, 3, -10]
    #création d'une liste vide
    liste_impairs = []
    #passage en revue des éléments de la liste à traiter
    for nombre in liste:
        #est ce un nombre impair ?
        if nombre % 2 != 0:
            #oui, nous pouvons l'ajouter
            liste_impairs.append(nombre)
    #affichage du résultat pour contrôle
    print(liste_impairs)
    #approche différente...
    liste_impairs = []
    for nombre in liste:
        #la différence est ici: le test est plus simple car 1 vaut pour True, comme toute valeur différente de 0
        if nombre % 2:
            liste_impairs.append(nombre)
    print(liste_impairs)
    #nouvelle approche: limiter les "." dans les boucles
    liste_impairs = []
    #récupérer une référence directe à la méthode append
    append_liste = liste_impairs.append
    for nombre in liste:
        if nombre % 2:
            #et utiliser cette référence, donc, sans "."
            append_liste(nombre)
    print(liste_impairs)
    # exercice : sortir la liste des nombres impairs (par liste de comprehension)
    liste_impairs = [nombre for nombre in liste if nombre % 2 != 0]#à noter: le bloc "if" est optionnel
    print(liste_impairs)

    # exercice : afficher toutes les tables de multiplication
    valeurs = range(0, 11)
    #première approche fonctionnelle
    #pour toutes les tables
    for table in valeurs:
        #j'affiche la table en cours de traitement
        print(f'Table de  {table}:')
        #pour toutes les lignes de la table en cours
        for ligne_table in valeurs:
            #affichage d'une ligne par format
            print("{} X {} = {}".format(table,ligne_table, table * ligne_table))
            #affichage d'une ligne par print
            print(table,' X ',ligne_table,' = ', table * ligne_table)
    #seconde approche: éviter de créer des chaines de caractères à chaque tour de boucle
    #nous utilisons donc des modèles de chaines, créés une fois, et remplis à chaque tour (1 objet en moins créé)
    modele_ligne = "{} X {} = {}"
    for table in valeurs:
        print(f'Table de  {table}:')
        for ligne_table in valeurs:
            print(modele_ligne.format(table, ligne_table, table * ligne_table))
            print(table, ' X ', ligne_table, ' = ', table * ligne_table)

    #dernière approche: nous gagnons un "." en ayant directement une référence vers la méthode "format"
    formatage_ligne = "{} X {} = {}".format
    for table in valeurs:
        print(f"Table de  {table}:")
        for ligne_table in valeurs:
            print(formatage_ligne(table, ligne_table, table * ligne_table))
            print(table, "X", ligne_table, "=", table * ligne_table)

    # exercice : afficher les phrases qui sont des hétérogrammes (une lettre présent au max 1 fois)
    phrases = [
        "Lampez un fort whisky",
        "The quick brown fox jumps over the lazy dog",
        "Plombez vingt fuyards",
        "The big dwarf only jumps",
        "Allons enfants de la patrie",
        "Tu l'as trop ecrase cesar ton port salut",
    ]
    #pour chaque phrase
    for une_phrase in phrases:
        #nous partons du principe que la phrase est bien un hétérogramme
        est_heterogramme = True
        #pour chaque caractère de la phrase
        for caractere in une_phrase:
            #est ce une lettre ?
            if caractere in ascii_lowercase:
                #oui, dans ce cas, je compte le nombre de fois où la lettre est présente
                presence = une_phrase.count(caractere)
                #est ce un cas d'exclusion ?
                if presence > 1:
                    #oui... je mets le drapeau à vrai
                    est_heterogramme = False
                    #pas la peine d'aller plus loin, nous pouvons sortir de la boucle
                    break
        #test final, et affichage si la phrase en cours est bien un hétérogramme !
        if est_heterogramme:
            print(une_phrase)

    #seconde approche: passer au caractère suivant (ie, relance la boucle au plus tôt) pour tout ce qui n'est pas une lettre !
    for une_phrase in phrases:
        est_heterogramme = True
        for caractere in une_phrase:
            #mon test, et renvoi à l'itération suivante immédiatement
            if caractere not in ascii_lowercase:
                continue
            #ce code est donc lu uniquement pour les lettres !
            presence = une_phrase.count(caractere)
            if presence > 1:
                est_heterogramme = False
                break
        if est_heterogramme:
            print(une_phrase)
    #Dernière approche: plus de drapeau/flag: nous utilisons le fonctionnement du else associé à la boucle for !
    for une_phrase in phrases:
        for caractere in une_phrase:
            if caractere not in ascii_lowercase:
                continue
            presence = une_phrase.count(caractere)
            if presence > 1:
                break
        else:
            #je rentre dans le else uniquement si je n'ai pas rencontré de "break"
            print(une_phrase)
    # exercice : afficher les phrases qui sont des pangrammes (toutes les lettres de l'alphabet (au moins 1 fois))
    phrases = [
        "Portez ce vieux whisky au juge blond qui fume",
        "The quick brown fox jumps over the lazy dog",
        "Voix ambiguë d'un coeur qui au zéphyr préfère les jattes de kiwis",
        "Vif juge, trempez ce blond whisky aqueux",
        "Fripon, mixez l'abject whisky qui vidange",
        "Prouvez, juge, que le fameux sandwich au yak tue",
        "Buvez de ce bourbon que le patron juge fameux",
        "Voyez le brick énorme que j'examine près du wharf",
    ]
    #pour chaque phrase
    for une_phrase in phrases:
        # nous partons du principe que la phrase est bien un pangramme
        est_pangramme = True
        #utilisation d'une phrase en minuscule pour les tests, car nous utilisons les lettres de l'alphabet en minuscule
        phrase_minuscule = une_phrase.lower()
        #pour chaque lettre de l'alphabet
        for lettre in ascii_lowercase:
            #test de présence ?
            presence = phrase_minuscule.count(lettre)
            if presence == 0:
                #le cas est bloquant: cela ne peut être un pangramme !
                est_pangramme = False
                #nous sortons de la boucle, pas besoin d'aller plus loin...
                break
        #sortie de boucle: quid de cette phrase ?
        if est_pangramme:
            #affichage car le flag est resté à vrai !
            print(une_phrase)
    # exercice : dire quels sont les palindromes dans la liste de mots
    mots = [
        "radar",
        "kayak",
        "voiture",
        "Ressasser",
        "1234+8765=9999=5678+4321",
    ]
    #pour chaque mot
    for mot in mots:
        #pour le test, passage en minuscule
        mot_minus = mot.lower()
        #on compare le mot, et son inverse
        if mot_minus == mot_minus[::-1]:
            #cela fonctionne !
            print(mot)

    # exercice : trier les planetes par la taille de leur rayon
    Venus = {"rayon": 6051, "nom": "Venus"}
    Mercure = {"rayon": 2439, "nom": "Mercure"}
    Terre = {"rayon": 6378, "nom": "Terre"}
    Pluton = {"nom": "Pluton"}
    planetes = [Venus, Mercure, Terre, Pluton]

    def recuperer_rayon(une_planete: dict) -> int:
        """
        permet de renvoyer le rayon d'une planète
        :param une_planete: type dict
        :return: type integer, le rayon
        """
        #il s'agit d'un dictionnaire; je prends la valeur pour la clé rayon, 0 si pas d'informations/clé
        le_rayon: int = une_planete.get("rayon", 0)
        return le_rayon

    #pour affichage la docstring, ie, la documentation de ma fonction
    help(recuperer_rayon)
    #je teste ma fonction sur une planète
    rayon_venus = recuperer_rayon(Venus)
    #j'effectue un tri en utilisant ma fonction,ie, un tri par rayon
    planetes.sort(key=recuperer_rayon)
    #est ce bon ?
    print(planetes)
