from logging import getLogger, ERROR, Formatter
from logging.handlers import RotatingFileHandler
#module central pour gérer un système de log... ici dédié aux fonctions césar
loggeur_cesar = getLogger('cesar')
#on filtre: uniquement les niveaux erreur et critique
loggeur_cesar.setLevel(ERROR)
#mise en place d'un traitement des messages: ici, ajout dans un fichier, 1Mo max et historique sur 2 fichiers (on écrase le premier ensuite)
traitement_log = RotatingFileHandler('cesar.log', backupCount=2, maxBytes=1000000)
#même niveau de filtre
traitement_log.setLevel(ERROR)
#formattage du format d'affichage des logs
formateur = Formatter('%(asctime)s - %(levelname)s - %(message)s')
traitement_log.setFormatter(formateur)
#ajout de notre traitement au système de log... il ne reste plus qu'à importer l'objet derrière la variable dans les modules python
loggeur_cesar.addHandler(traitement_log)
