from csv import reader as reader_csv
from csv import writer as writer_csv
from pandas import read_csv
from matplotlib import pyplot as plt
from os import remove
from os.path import isfile
from sqlite3 import connect

class Sonde:
    """
    permettre de gérer un fichier de Sonde
    """
    def __init__(self, chemin_fichier:str):
        """
        le constructeur
        :param chemin_fichier: emplacement du fichier CSV de sonde
        """
        #via une propriété, je conserve le chemin du fichier passé à la construction
        self.__chemin = chemin_fichier
        #gestion d'un flag: est ce que le fichier a été nettoyé ?
        self.__fichier_ok = False

    def nettoyer(self):
        """
        méthode pour nettoyer le fichier et avoir uniquement un format CSV
        :return:None, le fichier est enregistré au même emplacement
        """
        #TODO: utiliser un try pour l'écriture pour ne pas planter le programme en cas d'erreur !
        #structure pour sauver les lignes qui vont être conservées après nettoyage
        lignes = []
        #ouverture du fichier en lecture; à noter, on impose l'encodage pour ne pas avoir de mauvaise surprise
        #todo: test, vérifier que le fichier existe !
        with open(self.__chemin,'r',encoding='utf-8') as fichier_csv:
            #parseur CSV "standard";
            moulinette_csv = reader_csv(fichier_csv,delimiter=",", lineterminator="\n")
            #pour chaque ligne du fichier
            for ligne in moulinette_csv:
                #est ce une ligne avec 7 colonnes... donc, une bonne ligne !
                if len(ligne) == 7:
                    #oui, je l'ajoute
                    #TODO: sortir le "." de la boucle
                    lignes.append(ligne)
        #toutes les bonnes lignes sont chargées en mémoire...
        #j'ouvre le fichier en écriture (remplace le contenu)
        with open(self.__chemin,'w',encoding='utf-8') as fichier_csv:
            #je créé un parseur CSV en écriture
            moulinette_csv = writer_csv(fichier_csv, delimiter=',',lineterminator="\n")
            #j'écris toutes les lignes en 1 seule fois
            moulinette_csv.writerows(lignes)
        #tout est fini: le fichier est bien nettoyé !
        self.__fichier_ok = True

    def __recuperer_donnees(self, nom_colonne:str,deb_mission:int=-1)->list:
        """
        permet de récupérer les données d'une colonne nommée du fichier CSV, avec une option
        pour filtrer sur le premier jour de mission
        :param nom_colonne: type str, le nom de la colonne du CSV
        :param deb_mission: type int, optionnel: le premier jour de mission à prendre en compte
        :return:type list, la liste des valeurs pour la colonne choisie
        """
        #uniquement si le fichier est nettoyé !
        resultat = []
        if self.__fichier_ok:
            jeu_donnees = read_csv(self.__chemin)
            if deb_mission != -1:
                resultat = jeu_donnees.loc[jeu_donnees['Mission Day'] > deb_mission, nom_colonne]
            else:
                resultat = jeu_donnees[nom_colonne]
        return resultat

    def afficher_graphe(self,nom_colonne:str, deb_mission:int=-1)->None:
        """
        afficher sous forme d'un graphe les données d'une colonne, avec une option
        pour filtrer sur le premier jour de mission
        :param nom_colonne: type str, le nom de la colonne du CSV
        :param deb_mission: type int, optionnel: le premier jour de mission à prendre en compte
        :return: None
        """
        #test: action uniquement si le fichier est nettoyé !
        if self.__fichier_ok:
            #récupération de la série de données
            resultat = self.__recuperer_donnees(nom_colonne,deb_mission)
            #création du tracé
            fig, ax = plt.subplots()
            #injection de la série de données (ordonnées)
            ax.plot(resultat)
            #positionnement d'un titre pour le tracé
            ax.set_title("Colonne {}".format(nom_colonne))
            #affichage du graphe
            plt.show()
            #à noter: l'interpréteur est bloqué tant que la fenêtre de visualisation est ouverte
            print('Fini !')
            #en option: sauvegarde sous forme d'un fichier image
            label = (nom_colonne, '2024', '12')
            fig.savefig('fig_{}_{}_{}.png'.format(*label))


    def sauver_sql(self, chemin_bdd:str)->None:
        """
        sauver la colonne temp_max dans une table SQL, dans la BDD passée en entrée
        :param chemin_bdd: chemin du fichier de la BDD
        :return: None
        """
        #est ce que le fichier est nettoyé ?
        if self.__fichier_ok:
            #est ce que le fichier existe déjà ?
            if isfile(chemin_bdd):
                #oui, alors on le supprime, ie, on supprime la BDD
                remove(chemin_bdd)
        #tout est prêt, création d'une BDD depuis le fichier
        with connect(chemin_bdd) as connexion_bdd:
            #création d'une transaction
            curseur = connexion_bdd.cursor()
            #création de la table
            curseur.execute("CREATE TABLE temp_max (jour,valeur);")
            #récupération des données
            donnees = self.__recuperer_donnees("Max Temp")
            #création du jeu de données à injecter dans la table
            jeu_donnees_sql = []
            for jour,une_valeur in enumerate(donnees):
                jeu_donnees_sql.append((jour,une_valeur))
            #injection des données
            curseur.executemany("INSERT INTO temp_max VALUES (?,?)",jeu_donnees_sql)
            #récupération d'une série de données entre 2 jours (test pour valider le contenu de la table)
            retour_sql = curseur.execute("SELECT * FROM temp_max WHERE jour>50 AND jour<60;")
            print(retour_sql.fetchall())







