from random import randint
from string import ascii_lowercase
# Liste des mots du pendu
liste_mots = [
    "armoire",
    "boucle",
    "buisson",
    "bureau",
    "chaise",
    "carton",
    "couteau",
    "fichier",
    "garage",
    "glace",
    "journal",
    "kiwi",
    "lampe",
    "liste",
    "montagne",
    "remise",
    "sandale",
    "taxi",
    "vampire",
    "volant",
]

class JeuPendu:
    """
    pour gérer un jeu de pendu
    """
    def __init__(self, nombre_erreurs:int):
        """
        constructeur: mise en place des attributs et éléments nécessaires au bon fonctionnement du jeu
        :param nombre_erreurs: type int, nombre d'erreurs possibles avant défaite
        """
        #positionnement de tous les attributs: le rattachement à self permet un accès à ces informations
        #dans toutes les méthodes
        #rattachement pour compter les erreurs
        self.__erreurs = nombre_erreurs
        #récupération d'un nombre aléatoire...
        position = randint(0, len(liste_mots) - 1)
        #pour une position aléatoire dans la liste de mots
        self.__mot_aleatoire = liste_mots[position]
        taille_mot = len(self.__mot_aleatoire)
        #création, sous forme d'une liste de lettres, du mot qui va se dévoiler
        self.__mot_en_cours = list('-'*taille_mot)
        #historique des lettres déjà saisies
        self.__lettres_deja_saisies = []

    def __remplacer_tirets(self, saisie:str):
        """
        méthode pour gérer le mot qui se dévoile
        :param saisie: type str, une lettre à dévoiler
        :return: None, action directe sur la liste du mot
        """
        #pour chaque lettre du mot à trouver
        for i, lettre in enumerate(self.__mot_aleatoire):
            #est ce que la lettre est égale à celle trouvée ?
            if saisie == lettre:
                #oui, alors, on remplace le tiret !
                self.__mot_en_cours[i] = saisie

    def __add__(self, ajout_chance:int)->None:
        """
        méthode de hack, compatible avec l'opération "+"
        :param ajout_chance: type int, le nombre d'erreurs en plus ;-)
        :return: None
        """
        #compatible uniquement avec des entiers, alors test ?
        if isinstance(ajout_chance, int):
            #c'est bien un entier, on ajoute un bonus !
            self.__erreurs += ajout_chance

    def __str__(self)->str:
        """
        méthode pour maitrise le rendu en chaine de caractères d'une partie
        :return: type str, l'état de la partie
        """
        #appel à la méthode privée dédiée
        return self.__afficher_partie(False)
    def __afficher_partie(self, avec_print=True)->str:
        """
        afficher l'état d'une partie sous forme d'une chaine de caractères
        :param avec_print: type bool, option: effectuer une print du rendu de l'état de la partie
        :return: type str, l'état de la partie
        """
        #passage du mot qui se dévoile en chaine (à partir du format liste)
        mot_chaine = ''.join(self.__mot_en_cours)
        #formtage de l'état de la partie
        partie = f"""Etat du mot: {mot_chaine}
Chance restante: {self.__erreurs}
"""
        #faut il faire un print ?
        if avec_print:
            #oui...
            print(partie)
        #renvoie de l'état de la partie
        return partie

    def __controler(self, saisie:str)->bool:
        """
        méthode pour effectuer tous les controles de saisie
        :param saisie: type str, la saisie
        :return: type bool, binaire: ok ou pas !
        """
        #soyons positif, tout est bon !
        test_ok = True
        #premier test, le plus large: longueur de la saisie
        if len(saisie)!=1:
            #souci: on alerte et on met à faux l'état du contrôle
            print('Il faut un seul caractère')
            test_ok = False
        #est ce bien une lettre ?
        elif saisie not in ascii_lowercase:
            # souci: on alerte et on met à faux l'état du contrôle
            print('Il faut une lettre')
            test_ok = False
        #lettre déjà saisie ?
        elif saisie in self.__lettres_deja_saisies:
            # souci: on alerte et on met à faux l'état du contrôle
            print('Lettre déjà saisie !')
            test_ok = False
        #si tout s'est bien passé, la variable est restée à True...
        return test_ok

    def lancer_partie(self)-> None:
        """
        méthode publique, principale: lancer la partie !
        :return: None
        """
        #variables de fin de partie: c'est gagné, ou le nombre d'erreurs max est atteint (ie, compteur à 0)
        gagne = False
        erreurs_max = False
        #tant que tout va bien !
        while not gagne and not erreurs_max:
            #permière étape: saisie une lettre
            saisie = input('Indiquer une lettre:')
            #pour éviter tout souci, passage en minuscule (cadeau, cela ne décompte pas d'erreur :-))
            saisie = saisie.lower()
            #appel au contrôle: tout est ok ?
            if not self.__controler(saisie):
                #non, on relance une saisie... et pas d'erreurs (encore un cadeau !)
                continue
            #pour les prochaines saisies, on garde l'historique de la lettre
            self.__lettres_deja_saisies.append(saisie)
            #est ce une bonne lettre ?
            if saisie in self.__mot_aleatoire:
                #oui
                print('Bonne pioche !')
                #on met à jour le mot qui se dévoile
                self.__remplacer_tirets(saisie)
            else:
                #oups...
                print('Mauvaise pioche !')
                #là, forcément, 1 point en moins !
                self.__erreurs = self.__erreurs - 1
            #dans tous les cas, on affiche l'état de la partie
            self.__afficher_partie()
            #mise à jour des variablers de fin de partie
            #trop d'erreurs ?
            erreurs_max =  self.__erreurs == 0
            #mot découvert ?
            gagne = '-' not in self.__mot_en_cours
        #nous sommes sortis de la boucle... mais pour quelle raison ?
        if gagne:
            print('Bravo !')
        else:
            print('Perdu !')





