from tkinter import Tk, Frame, Button, Text, END
from tkinter.filedialog import askdirectory
from libformation.fonctions_cesar import coder_cesar, decoder_cesar
from time import sleep
from threading import Thread

class ThreadDecoderCesar(Thread):
    """
    Classe pour passer en thread le decodage césar
    """
    def __init__(self, chemin_dossier:str, afficher_info:callable)->None:
        """
        constructeur: mise en place des propriétés nécessaires au traitement
        :param chemin_dossier: type str, l'emplacement du dossier à traiter
        :param afficher_info: callback, méthode à appeler pour envoyer des informations (à l'IHM par exemple ou des logs)
        """
        Thread.__init__(self)
        #association à des propriétés: les informations sont disponibles dans toutes les méthodes
        self.__chemin_dossier = chemin_dossier
        self.__afficher_info = afficher_info

    def run(self)->None:
        """
        le runner: méthode principale du thread
        :return: None
        """
        #pour temporiser, sinon, cela est trop rapide !
        sleep(5)
        #décodage à partir du dossier
        decoder_cesar(self.__chemin_dossier)
        #renvoi de l'information: tout est terminé
        self.__afficher_info('Traitement ok')
class Cesar:
    """
    classe pour proposer une IHM au codage, décodage césar
    """
    def __init__(self)->None:
        """
        constructeur: mise en place de l'IHM et lancement de l'interface (mainloop)
        """
        #Frame principale
        fenetre_principale = Tk()
        #frame secondaire pour gérer le bloc du haut
        frame_haut = Frame(fenetre_principale)
        frame_haut.pack()
        #création du bouton pour référencer le dossier à utiliser
        Button(frame_haut, text="Trouver dossier ?", command=self.__chercher_dossier).grid()
        #frame secondire, partie centrale de l'IHM
        frame_milieu = Frame(fenetre_principale)
        frame_milieu.pack()
        #boutons pour les traitements césar; à noter que le positionnement dans la frame s'effectue par grille
        Button(frame_milieu, text="Décoder", command=self.__decoder).grid(column=0, row=0)
        Button(frame_milieu, text="Coder", command=self.__coder).grid(column=1, row=0)
        #dernière partie une zone d'affichage de texte pour afficher les messages à l'utilisateur
        self.__zone_text = Text(fenetre_principale)
        self.__zone_text.pack()
        #variables nécessaires pour le fonctionnement des méthodes
        self.__fenetre_principale = fenetre_principale
        self.__chemin_dossier = ''


    def __chercher_dossier(self)->None:
        """
        méthode pour ouvrir une fenêtre et inviter l'utilisateur à choisir une dossier
        :return:
        """
        #quel dossier ? On stocke le choix dans la propriété pour l'utiliser dans les méthodes de traitement
        self.__chemin_dossier = askdirectory()
        #afficher du dossier choisi dans l'interface
        self.__afficher_info(f"Dossier {self.__chemin_dossier} bien sélectionné")

    def __afficher_info(self, message:str)->None:
        """
        méthode centrale pour afficher des messages dans l'interface
        :param message: type str, le message à afficher
        :return: None
        """
        self.__zone_text.insert(END,f"{message} \n")


    def lancer(self)->None:
        """
        Méthode publique pour lancer l'interface.
        Cela pourrait être fait dans le constructeur...
        :return:
        """
        #lancement de l'IHM
        self.__fenetre_principale.mainloop()

    def __decoder(self)->None:
        """
        méthode interne pour décoder
        :return: None
        """
        #contrôle: est ce que le chemin du dossier a bien été choisi ?
        if self.__chemin_dossier != '':
            #oui, nous créons un thread de traitement avec le dossier choisi, et la méthode d'affichage de message
            job = ThreadDecoderCesar(self.__chemin_dossier, self.__afficher_info)
            #lancement du thread, ie, on exécute la méthode run()
            job.start()
        else:
            #message d'erreur: il faut choisir un dossier d'abord !
            self.__afficher_info("Choisir d'abord un dossier")


    def __coder(self)->None:
        """
        méthode interne pour décoder
        :return: None
        """
        # contrôle: est ce que le chemin du dossier a bien été choisi ?
        if self.__chemin_dossier != '':
            #ici, fonctionnement sans thread: l'IHM est bloqué tant que le traitement n'est pas terminé...
            coder_cesar(self.__chemin_dossier)
            #affichage de fin de traitement (puisque si on arrive à cette ligne, nous sommes sortis de la fonction coder_cesar)
            self.__afficher_info("Traitement ok")
        else:
            # message d'erreur: il faut choisir un dossier d'abord !
            self.__afficher_info("Choisir d'abord un dossier")