url_api = 'https://api.met.no/weatherapi/locationforecast/2.0/classic?lat={}&lon={}&altitude={}'
user_agent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:133.0) Gecko/20100101 Firefox/133.0"
from requests import get
from bs4 import BeautifulSoup
from statistics import mean
def recuperer_temp(latitute:float, longitude:float, altitude:int)->float:
    """
    méthode pour afficher la temperature moyenne sous tous les jours à venir à partir des coordonnées GPS du lieu
    :param latitute: type float, la latitude
    :param longitude: type float, la longitude
    :param altitude: type int, l'altitude
    :return: type float, la températeur moyenne
    """
    #appel de l'api, avec l'url formatée; à noter la surchage de l'agent pour simuler un navigateur
    with get(url_api.format(latitute, longitude, altitude),
                             headers={'user-agent':user_agent}) as page_xml:
        #récupération du contenu de la page, sous forme de chaine de caractères
        contenu:str = page_xml.text
    #on décrémente pour fermer le pont réseau (socket)
    #on transforme notre chaine en 1 objet capable de manipuler du XML
    soupe_xml = BeautifulSoup(contenu, features='html.parser')
    #liste pour stocker toutes les températures trouvées
    temperatures =[]
    #pour chaque balise "time"
    for balise_time in soupe_xml.find_all('time'):
        #dans cette balise, pour chaque balise température
        for balise_temp in balise_time.find_all('temperature'):
            #récupération de l'attribut "value"
            valeur = balise_temp['value']
            #ajout dans la liste: attention, l'information est en str !
            temperatures.append(valeur)
    #transformation de toutes les valeurs str en float
    temperatures = list(map(float, temperatures))
    #renvoie de la valeur moyenne !
    return mean(temperatures)

