"""
module de définition des fonctions pour le chiffrement césar
"""
from string import ascii_letters
from os import listdir
from os.path import join, isfile
from os.path import isdir
from os import mkdir, sep
from libformation.mon_loggeur import loggeur_cesar

def chiffrer_cesar(message:str,decalage:int)->str:
    """
    fonction centrale pour chiffrer à la manière de cesar
    :param message:type str, le message à chiffrer
    :param decalage: type int, le décalage à opérer, ie, coder/décoder
    :return: type str, le message chiffré/déchiffré
    """
    #structure type liste pour stocker le nouveau message après traitement
    nouveau_message = []
    #avoir une référence directe vers la méthode d'ajout (retirer le "." dans la boucle)
    append_message = nouveau_message.append
    #idem pour la méthode index
    ascii_letters_index = ascii_letters.index
    #la taille est à calculer une seule fois
    taille_ascii = len(ascii_letters)
    #pour chaque caractère du message
    for caractere in message:
        #est ce une lettre ?
        if caractere in ascii_letters:
            #oui, alors on peut effectuer un traitement
            #récupération de la position
            position_lettre = ascii_letters_index(caractere)
            #récupération de la nouvelle position; le modulo permet d'éviter les dépassements de position
            nouvelle_position_lettre = (position_lettre + decalage) % taille_ascii
            #récupération de la lettre correspondant à la nouvelle position
            nouvelle_lettre = ascii_letters[nouvelle_position_lettre]
            #ajout de la lettre au message
            append_message(nouvelle_lettre)
        else:
            #on en touche à rien, on ajoute le caractère (espace, ponctuation, etc) en l'état
            append_message(caractere)
    #nous devons renvoyer une chaine de caractères: il faut "jointer" les éléments de la liste !
    return ''.join(nouveau_message)

def lister_chemins_fichiers(chemin_dossier:str)->list:
    """
    fonction pour lister les fichiers d'un dossier, renvoie les chemins de ces fichiers en liste
    :param chemin_dossier: type str, l'emplacement du dossier à lister
    :return: type liste, les emplacements des fichiers du dossier
    """
    #on peut de trace sur notre traitement... ici, niveau debug... juste de l'information
    loggeur_cesar.debug("Je rentre dans la fonction lister chemins fichiers")
    #la liste des chemins qui va se peupler
    chemins = []
    #contrôle: est ce bien un dossier ?
    if isdir(chemin_dossier):
        #oui, alors faisons un parcours
        for nom_fichier in listdir(chemin_dossier):
            #reconstruisons le chemin
            chemin_fichier = join(chemin_dossier,nom_fichier)
            #est ce bien un fichier ? Txt ?
            #TODO: utiliser la lib mimetype pour vérifier que c'est un fichier txt !
            if isfile(chemin_fichier) and '.txt' in nom_fichier:
                #oui !
                chemins.append(chemin_fichier)
    else:
        #c'est une erreur; on trace le cas !
        loggeur_cesar.critical("Erreur: {} n'est pas un dossier".format(chemin_dossier))
    #on retourne la liste des emplacements trouvés
    return chemins

def ecrire_fichier(contenu:str, dossier_origine:str, chemin_fichier:str)->int:
    """
    fonction pour écrire le contenu dans un fichier, fichier qui sera dans un dossier renommé à partir du nom du dossier d'origine
    :param contenu: type str, le contenu à écrire
    :param dossier_origine: type str, l'emplacement du dossier d'origine
    :param chemin_fichier: type str, l'emplacement du fichier à l'origine du contenu
    :return: type int, l'état du traitement; 0 si ok, 1 si erreur d'écriture
    """
    #emplacement du nouveau dossier
    nouveau_dossier = "{}_traites".format(dossier_origine)
    #est ce qu'il existe ?
    if not isdir(nouveau_dossier):
        #non, alors il faut le créer !
        mkdir(nouveau_dossier)
    #récupérons le nom du fichier d'origine
    #éclatons le chemin par les "/" ou "\" selon l'OS
    chemin_explose = chemin_fichier.split(sep)
    #c'est normalement le dernier morceau du chemin éclaté
    nom_fichier = chemin_explose[-1]
    try:
        #essayons de faire une écriture avec le nouvel emplacement
        with open(join(nouveau_dossier,nom_fichier),'w', encoding='utf-8') as fichier_ecrire:
            fichier_ecrire.write(contenu)
    except IOError:
        #une erreur... on trace
        loggeur_cesar.error('Erreur lors en écriture du fichier {}'.format(chemin_fichier))
        #retour d'erreur
        return 1
    #retour ok
    return 0

def traiter_cesar(chemin_dossier:str, decalage:int)->int:
    """
    fonction centrale pour effectuer le traitement d'un dossier
    :param chemin_dossier: type str, l'emplacement du dossier à traiter
    :param decalage: type int, le décalage selon le traitement attendu
    :return: type int, le statut du traitement: 0 si tout est ok, nombre d'erreurs sinon
    """
    #code par défaut: tout va bien !
    codes_retour = 0
    #pour chaque fichier; pas de contrôle de l'existence... vu plus tard
    for chemin_fichier in lister_chemins_fichiers(chemin_dossier):
        #j'ouvre le fichier txt
        with open(chemin_fichier,'r',encoding='utf-8') as fichier_lecture:
            #je parcours son contenu
            contenu = fichier_lecture.read()
        #je décrémente pour libérer le fichier ouvert en lecture
        #je lance le traitement sur le contenu
        nouveau_contenu = chiffrer_cesar(contenu,decalage)
        #écriture du fichier traité
        code_retour = ecrire_fichier(nouveau_contenu,chemin_dossier,chemin_fichier)
        #prise en compte du statut
        codes_retour += code_retour
    #renvoi du statut
    return codes_retour

def decoder_cesar(chemin_dossier:str)->int:
    """
    fonction pour décoder les fichiers d'un dossier
    :param chemin_dossier:type str, l'emplacement du dossier dont les fichiers sont à décoder
    :return: type int,0 si tout s'est bien passé
    """
    return traiter_cesar(chemin_dossier, -13)
def coder_cesar(chemin_dossier:str):
    """
    fonction pour coder les fichiers d'un dossier
    :param chemin_dossier:type str, l'emplacement du dossier dont les fichiers sont à coder
    :return: type int,0 si tout s'est bien passé
    """
    return traiter_cesar(chemin_dossier, 13)


#ici, nous faison des tests... si le module est importé, les tests ne sont pas joués !
if __name__ == '__main__':
    retour = chiffrer_cesar('nicolas',13)
    print(retour)
    retour_normal = chiffrer_cesar(retour,-13)
    print(retour_normal)
    liste = lister_chemins_fichiers(join('..','fichiers_codes'))
    print(liste)