"""
Module de définition du juste prix !
"""
#imports nécessaires au fonctionnement
from random import randrange

class JustePrix:
    """
    classe pour simuler une partie du juste prix
    """
    def __init__(self) -> None:
        """
        Constructeur. L'objectif est de préparer les données du jeu
        En entrée: 
        - Rien
        Sortie:
        - Rien 
        """
        #mise en place des paramètres: on boucle tant que ce n'est pas bon !
        ok = False
        while not ok:
            #récupération des informations
            min_val = input("Valeur minimum: ")
            max_val = input("Valeur maximum: ")
            nb_erreurs = input("Nombre d'essais tolérés : ")
            #transformation en entiers
            try:
                min_val = int(min_val)
                max_val = int(max_val)
                nb_erreurs = int(nb_erreurs)
                #si on arrive ici, c'est que tout s'est bien déroulé
                ok = True
            except:
                #il y a un souci: on avertit l'utilisateur
                print('Erreur lors de la saisie. Merci de recommencer')
        #positionnement de la valeur par défaut
        #passage en privé ;-)
        self.__valeur_choisie = randrange(min_val, max_val)
        #le compteur d'erreurs
        self.nb_erreurs = nb_erreurs
    
    def lancer_partie(self):
        """
        Méthode pour lancer une partie
        En entrée: 
        - Rien
        Sortie:
        - Rien 
        """
        #les conditions pour gérer la fin de partie
        trouve = False
        perdu = False
        #tant qu'il n'y a pas une condition d'arrêt
        while not trouve and not perdu:
            #l'utilisateur saisit sa valeur
            try:
                valeur_proposee = int(input("Votre valeur ?"))
            except:
                print("Il faut saisir un entier ! ")
                continue
            #à ce stade, nous avons une bonne saisie
            #vérification du cas
            if valeur_proposee!=self.__valeur_choisie:
                #il n'a pas trouvé... on décrémente
                self.nb_erreurs = self.nb_erreurs -1
                #on l'aide :-)
                if valeur_proposee>self.__valeur_choisie:
                    print("C'est moins")
                else:
                    print("C'est plus")
            #nous mettons à jour les conditions de fin de partie
            trouve = valeur_proposee == self.__valeur_choisie
            perdu = self.nb_erreurs == 0
        #nous sommes sortis de la boucle, mais pourquoi ?
        if trouve:
            print("Bravo, c'est gagné")
        else:
            print("Perdu... dommage")

if __name__ == "__main__":
    #programme principal
    partie = 'oui'
    #on boucle tant que l'on veut jouer !
    while partie =='oui':
        #création d'une nouvelle partie
        jeu = JustePrix()
        #lancement
        jeu.lancer_partie()
        #encore une partie ?
        partie = input('Nouvelle partie ? oui, non: ')
