import timeit

def carre(a):
    return a**2


#nous voulons appliquer un carre a tous les entiers d'une liste. Trois approches a tester
#par iterator 
def pow_1(alist):
    return list(map(carre,alist))
#par le liste de comprehension
def pow_2(alist):
    return [item**2 for item in alist]
#par approche basique
def pow_3(alist):
    res = []
    for item in alist:
        res.append(item**2)
    return res

#lancer des tests de perfs (test unitaire) :
t = timeit.Timer('pow_1('+repr(range(1,10))+')','from __main__ import pow_1')
duree = t.timeit(number=1000)
print(duree)

t = timeit.Timer('pow_2('+repr(range(1,10))+')','from __main__ import pow_2')
print(t.timeit(number=1000))

t = timeit.Timer('pow_3('+repr(range(1,10))+')','from __main__ import pow_3')
print(t.timeit(number=1000))

#via profil
"""Sorting a large, randomly generated string and writing it to disk"""
import random

#@profile
def write_sorted_letters(nb_letters=10**7):
    random_string = ''
    for i in range(nb_letters):
        random_string += random.choice('abcdefghijklmnopqrstuvwxyz')
    sorted_string = sorted(random_string)

    with open("sorted_text.txt", "w") as sorted_text:
        for character in sorted_string:
            sorted_text.write(character)

#lors de l'appel complet
#python -m cProfile -s tottime your_program.py
import cProfile
cp = cProfile.Profile()
cp.enable()
write_sorted_letters()
cp.disable()
cp.print_stats()
