#coding:utf-8
from random import randint
# Liste des mots du pendu
liste_mots = [
    "armoire",
    "boucle",
    "buisson",
    "bureau",
    "chaise",
    "carton",
    "couteau",
    "fichier",
    "garage",
    "glace",
    "journal",
    "kiwi",
    "lampe",
    "liste",
    "montagne",
    "remise",
    "sandale",
    "taxi",
    "vampire",
    "volant",
]

class Pendu:
    """
    jeu du pendu
    """
    def __init__(self, nb_erreurs:int)->None:
        """
        constructeur; prend le nombre d'erreurs possible en entrée
        :param nb_erreur: type int, nombre d'erreurs
        """
        self.nb_erreurs = nb_erreurs

    def lancer(self)->None:
        """
        lancer la boucle du jeu
        :return:None
        """
        #création des variables nécessaires au fonctionnement du jeu
        mot_trouve = False
        nombre_tours_passes = 0
        #mot à trouver au hasard à partir de la liste des mots proposés ci-dessus
        mot_a_trouver = liste_mots[randint(0,len(liste_mots)-1)]
        #les lettres déjà utilisés
        lettres_deja_utilisees = []
        #la liste des lettres trouvées positionnées dans le mot à trouver; par défaut, uniquement des "_"
        mot_en_cours = list('_'*len(mot_a_trouver))

        #boucle sous condition: si non trouvé, et si nombre d'erreurs sous la limite
        while not mot_trouve and nombre_tours_passes<=self.nb_erreurs:
            #récupération d'une lettre à saisie
            lettre = input('Donner une lettre :')
            if lettre in lettres_deja_utilisees:
                #retour à la case départ, lettre déjà proposée
                print("{} a déjà été utilisée".format(lettre))
                continue
            #ajouter la lettre
            lettres_deja_utilisees.append(lettre)
            #est elle présente ?
            if lettre in mot_a_trouver:
                #oui, récupération des positions de ces lettres
                positions = []
                for indice, lettre_mot in enumerate(mot_a_trouver):
                    if lettre_mot == lettre:
                        positions.append(indice)
                #mise à jour du mot en cours de révélation
                for position in positions:
                    mot_en_cours[position] = lettre
                #affichage du résultat
                print('Bonne lettre : {}'.format(lettre))
            else:
                #non, la lettre n'est pas présente...
                nombre_tours_passes += 1
                print("{} n'est pas dans le mot, essaie encore !".format(lettre))
            print(''.join(mot_en_cours))
            #est ce que le mot est trouvé ?
            if '_' not in mot_en_cours:
                #condition de sortie
                mot_trouve = True

        if mot_trouve==True:
            print('Bravo !')
        else:
            print('Perdu')

if __name__=='__main__':
    #Programme principal: on peut lancer plusieurs parties !
    saisie = 'o'
    while saisie=='o':
        nb_erreurs = int(input("Indiquer le nombre d'erreurs possible:"))
        jeu_pendu = Pendu(nb_erreurs)
        jeu_pendu.lancer()
        saisie = input('Nouvelle partie ? o (oui) ou n (non)')
    print("Merci d'avoir joué !")

