# -*coding: UTF-8 -*-
__author__ = 'nicolasperrier'

#version simple d'un décorateur :
def mon_deco(mafonction):
    """ """
    print("on rentre dans le decorateur")
    return mafonction

@mon_deco
def bonjour():
    print("Salut !")


#version avancée
def mon_deco_2(mafonction):

    print("on rentre dans le decorateur")
    def bonjour_italien():
        print('buongiorno !')



    return bonjour_italien

@mon_deco_2
def bonjour_bis():
    print('Salut')


#Application: decorateur pour contrôler les entrées utilisées pour faire ma somme
def deco_somme():
    """
    :return:
    """
    def deco(fonction_somme):
        def fonction_modifiee(*args):
            """
            :param args:
            :return:
            """
            #filtrer les bonnes valeurs pour faire l'appel
            mesArgs = [int(elem) for elem in args if (type(elem)==type('') and elem.isdigit()) or type(elem)==type(5)]
            return fonction_somme(*mesArgs)
        return fonction_modifiee

    return deco

@deco_somme()
def somme(*args):
    total = 0
    for elem in args:
        total += elem
    return total


if __name__ == '__main__':
    #les tests :
    bonjour()
    bonjour_bis()
    print(somme(0,5,57))
    print(somme(0,'5','57'))
    print(somme(0, '5', '57','bob'))

