﻿# -*- coding: utf-8 -*-
import pdb

class Acteur():
    """ classe pour gerer les acteurs"""
    
    def __init__(self, nom,prenom=''):
        """ constructeur simple"""
        self.__nomActeur = nom
        self.__prenomActeur = prenom
        
    def getNomActeur(self):
        """recuperer le nom de l'acteur"""
        return self.__nomActeur
    
    def setNomActeur(self,nouveau_nom):
        """ positionne le nom de l'acteur"""
        self.__nomActeur = nouveau_nom
        
        
    def getPrenomActeur(self):
        """recuperer le prenom de l'acteur"""
        return self.__prenomActeur
    
    def setPrenomActeur(self,nouveau_prenom):
        """ positionne le prenom de l'acteur"""
        self.__prenomActeur = nouveau_prenom
        
    def estMonJumeau(self, acteur):
        """ voir si on a le meme nom. Retourne vrai ou faux"""  
        test1 = self.__nomActeur == acteur.getNomActeur()
        test2 = self.__prenomActeur == acteur.getPrenomActeur()
        return test1 and test2  
    
    def __eq__(self, acteur):
        """ compatibilite avec == du langage"""
        return self.estMonJumeau(acteur)
        
    def __str__(self):
        """comportement chaine de caracteres """
        return 'Acteur est : %s %s ' % (self.getPrenomActeur(),self.getNomActeur())
    
    
class UnFilm:
    def __init__(self, titre, annee, acteurs = []):
        """ constructeur simple"""
        self.__titre = titre
        self.__annee = annee  
        self.__acteurs = acteurs
        
    def getTitre(self):  
        """ getter titre"""
        return self.__titre
    
    def setTitre(self,autre_titre):
        """ setter titre """
        self.__titre = autre_titre
        
    def ajouterActeur(self, acteur):
        """ ajouter des acteurs"""
        estPresent = False
        for act in self.__acteurs:
            if act==acteur:#act.estMonJumeau(acteur):
                estPresent = True
                break
        if not estPresent:
            self.__acteurs.append(acteur)
        else:
            print('Acteur deja present %s'  % str(acteur))
        
    def __str__(self):
        """ pour impression """
        return """Titre : %(titre)s
                  Année : %(annee)i
                  Acteurs : %(acteurs)s
        """ % {'titre':self.getTitre(),
               'annee':self.__annee,
               'acteurs':',\n'.join([str(act) for act in self.__acteurs])
               }

if __name__=='__main__':        
    act = Acteur('perrier')
    print(act.getNomActeur())
    act.setNomActeur('le guen')
    print(act.getNomActeur())
    Acteur.getNomActeur(act)
    print(act)
    film1 = UnFilm('Ifreme, le retour',2014)
    film1.ajouterActeur(act)
    print(film1)


