#coding:utf-8
#objectif : comparer temps de reponse/fluidité du rendu via bokeh ou via matplotlib pour l'impression du graphe
import numpy as np
import matplotlib.pyplot as plt
from bokeh.plotting import figure, output_file, show

if __name__=='__main__':
    # prepare some data
    N = 40000000
    x = np.random.random(size=N) * 100
    y = np.random.random(size=N) * 100

    #bokeh :
    # output to static HTML file
    output_file("line.html")

    p = figure(plot_width=400, plot_height=400)

    # add a circle renderer with a size, color, and alpha
    p.circle(x, y, size=0.1, color="navy", alpha=0.5)

    # show the results
    show(p)

    #matplotlib:
    plt.plot(x, y, 'ro')
    plt.show()