"""
module proposant des exercices sur le parsing xml
"""
# coding: utf-8
from bs4 import BeautifulSoup
from urllib.request import urlopen
from time import strptime


def temperature_de_ma_ville(ville: str, date: str) -> float:
    """
    à partir du nom d'une ville, renvoi la température moyenne pour une journée donnée
    :param ville: Brest par exemple
    :param date: au format JJ/MM/YYYY
    :return: float, temperature pour les jours à venir
    """

    date_debut = strptime(date + " 00:00", "%d/%m/%Y %H:%M")
    date_fin = strptime(date + " 23:59", "%d/%m/%Y %H:%M")
    try:
        mon_url = "http://www.yr.no/place/France/Brittany/{}/forecast.xml"\
                   .format(ville)
            #on continue: lecture du contenu distant
        with urlopen(mon_url) as fichier_distant:
            contenu = fichier_distant.read()
    except Exception as erreur:
        print('Accès url {} impossible. Erreur: {}'.formar(mon_url,erreur))
        return 0.


    #construction de l'arbre pour parsing xml
    arbre_xml = BeautifulSoup(contenu, "html.parser")
    # accès direct de proche en proche
    forecast = arbre_xml.weatherdata.forecast
    # accès par la recherche
    forecast = arbre_xml.find("forecast")
    #préparation de la séries des températures
    serie_temperatures:list = []
    #pointeur pour accès direct à la méthode append
    serie_append = serie_temperatures.append
    #pour chaque balise time
    for time_balise in forecast.find_all("time"):
        #récupération de la date de début de période, et conversion en objet date
        date_periode = time_balise["from"]
        date_periode_obj = strptime(date_periode, "%Y-%m-%dT%H:%M:00")
        #est ce que c'est la période choisie ?
        if date_debut < date_periode_obj < date_fin:
            #oui, récupération de la balise temperature
            temp_balise = time_balise.find("temperature")
            #récupération de l'attribut value
            temperature_string = temp_balise["value"]
            #conversion en int
            temp_entier = int(temperature_string)
            #et modification de l'arbre XML (pour le fun :-))
            temp_balise["value"] = temp_entier + 2
            #nouvelle balise soleil
            balise_soleil = arbre_xml.new_tag("soleil")
            balise_soleil["tendance"] = "beau fixe"
            time_balise.insert(0, balise_soleil)
            balise_couleur = arbre_xml.new_tag("couleur", rvb="#GFDGDFG")
            balise_soleil.append(balise_couleur)
            serie_append(temp_entier)
    #sauvegarde en local du nouvel arbre XML
    with open("meteo.xml", "w") as ecrire_meteo:
        ecrire_meteo.write(arbre_xml.prettify())
    #renvoi de la température moyenne (issue de la série)
    if serie_temperatures:
        return sum(serie_temperatures) / len(serie_temperatures)
    return 0.


if __name__ == "__main__":
    # on cherche a afficher le taux d'humidite rendu par le site de meteo yahoo sur Brest (dynamique)
    print(temperature_de_ma_ville("Brest", "23/11/2020"))
