#imports
import cProfile
from pycallgraph2 import PyCallGraph
from pycallgraph2.output import GraphvizOutput

def sonde_temps():
    """
    decorateur
    :param ma_fonction:
    :return:
    """
    def deco(function_orginale):
        def sonder(liste_entier):
            cp = cProfile.Profile()
            cp.enable()
            function_orginale(liste_entier)
            cp.disable()
            cp.print_stats()
        return sonder
    return deco

def carre(a):
    """
    fonction appliquant un carré à la valeur passée en argument
    :param a:
    :return:
    """
    return a**2


@sonde_temps()
def appliquer_carre(alist):
    """
    application du carré
    :param alist:
    :return:
    """
    return list(map(carre,alist))


if __name__ == '__main__':
    print(appliquer_carre(range(0,100000)))
    with PyCallGraph(output=GraphvizOutput(output_file='appliquer_carre.png')):
        appliquer_carre(range(0,100000))
