"""
Module proposant une application de recherche
d'un motif dans les fichiers d'une arbo
Interface tkinter
"""
__author__ = 'nicolasperrier'
from tkinter import Label, Button, Entry, Text, END, Tk, Menu
from tkinter.filedialog import askdirectory
from os import walk
from os.path import join
from mimetypes import guess_type
class ApplicationRecherche:
    """
    interface graphique pour l'application
    """
    def __init__(self)->None:
        """
        construction de l'interface graphique
        """
        #création de la Frame racine (mère de toutes)
        self.racine = racine = Tk()
        #initialisation pour stockage du dossier choisi
        self.chemin_dossier = ''

        #zone saisie mot
        Label(racine, text='Mot à rechercher : ').grid(row=0, column=0)
        self.mot = Entry(racine)
        self.mot.grid(row=0, column=1)

        #zone boutons
        Button(racine,command=self.trouver_dossier, text="Chercher dossier").grid(row=1, column=1)
        Button(racine, command=self.chercher, text="Chercher").grid(row=2, column=1)

        #zone texte
        Label(racine, text='Résultats : ').grid(row=3, column=0)
        self.texte = Text(racine)
        self.texte.grid(row=3, column=1)

        #Menu
        menubar = Menu(racine)
        filemenu = Menu(menubar, tearoff=0)
        filemenu.add_command(label="Fermer", command=self.fermer)
        menubar.add_cascade(label="Fichier", menu=filemenu)
        self.racine.config(menu=menubar)


    def fermer(self)->None:
        """
        permettre de quitter l'application suite à l'action du bouton fermer, menu fichier
        :return:
        """
        self.racine.quit()

    def trouver_dossier(self)->None:
        """
        permettre le choix d'un dossier
        :return:
        """
        #ouverture de la boite de dialogue
        self.chemin_dossier = askdirectory()
        #affichage dans la zone de texte
        self.texte.insert(END, 'Dossier choisi:  {}\n'.format(self.chemin_dossier))

    def chercher(self)->None:
        """
        lancement de la recherche dans l'arbo
        """
        #contrôle: choix du dossier ?
        if self.chemin_dossier=='':
            self.texte.insert(END,'Il faut  choisir un dossier !\n')
        else:
            #récupération du mot à rechercher
            mot_saisi = self.mot.get()
            #bien saisi ?
            if not mot_saisi.strip():
                self.texte.insert(END, 'Il faut  saisir un mot !\n')
            else:
                #parcours de l'arborescence
                for dossier_racine, dossiers_enfant, fichiers_enfant in walk(self.chemin_dossier):
                    #pour chaque fichier
                    for nom_fichier in fichiers_enfant:
                        #contrôle du type: uniquement de fichiers .py
                        type_fichier = guess_type(nom_fichier)
                        if 'text/x-python'==type_fichier[0]:
                            #construction du chemin du fichier
                            chemin_fichier = join(dossier_racine, nom_fichier)
                            try:
                                #ouverture en utf-8
                                with open(chemin_fichier,encoding='utf-8') as fichier_ouvert:
                                    #récupération du contenu
                                    contenu = fichier_ouvert.read()
                                #est ce présent dans le contenu ?
                                if self.__present_dans_texte(contenu, mot_saisi ):
                                    #oui, affichage !
                                    self.texte.insert(END, 'Fichier {}\n'.format(chemin_fichier))
                            except Exception as erreur:
                                #affichage en console (pb d'ouverture du fichier ?
                                print('Fichier KO {}, erreur: {}'.format(nom_fichier, erreur))


    def __present_dans_texte(self, texte:str, motif:str)->bool:
        """
        détermine la présence d'un motif dans le contenu de la chaine
        :return:
        """
        return motif in texte

    def lancer(self)->None:
        """
        permet de lancer l'application graphique
        :return:
        """
        self.racine.mainloop()

if __name__ == '__main__':
    #construction de l'application, et lancement
    appli = ApplicationRecherche()
    appli.lancer()
