#coding: utf-8
__author__ = 'nicolasperrier'

class Acteur(object):
    """
    Pour creer des acteurs
    """
    def __init__(self,prenom, nom, age=None):
        """
        :param prenom: chaine
        :param nom: chaine
        :param age: entier
        :return:
        """
        self.__nom = nom
        self.__age = age
        self.__prenom = prenom

    def get_nom_acteur(self):
        """recuperer le nom de l'acteur"""
        return self.__nom

    def set_nom_acteur(self,nouveau_nom):
        """ positionne le nom de l'acteur"""
        self.__nom = nouveau_nom

    def get_age_acteur(self):
        """recuperer l'age de l'acteur"""
        return self.__age

    def set_nom_acteur(self,nouvel_age):
        """ positionne l'age de l'acteur"""
        self.__age = nouvel_age


    def get_prenom_acteur(self):
        """recuperer le prenom de l'acteur"""
        return self.__prenom

    def set_prenom_acteur(self,nouveau_prenom):
        """ positionne le prenom de l'acteur"""
        self.__prenom = nouveau_prenom

    def estMonJumeau(self, acteur):
        """ voir si on a le meme nom. Retourne vrai ou faux"""
        test1 = self.__nom == acteur.get_nom_acteur()
        test2 = self.__prenom == acteur.get_prenom_acteur()
        if self.__age and acteur.get_age_acteur():
            test3 = self.__age == acteur.get_age_acteur()
        else:
            test3 = True
        return test1 and test2  and test3

    def __eq__(self, acteur):
        """ compatibilite avec == du langage"""
        return self.estMonJumeau(acteur)

    def __str__(self):
        """

        :return:
        """
        age = 'N/A'
        if self.__age:
            age = self.__age

        return '{} {}, {}'.format(self.__prenom,self.__nom, str(age))


if __name__=='__main__':
    act1 = Acteur('Robert','Deniro')
    act2 = Acteur('Nicolas','Perrier',35)
    print(act1)
    print(act2)

    print (act1==act2)