#!/bin/environment python
# -*- encoding utf-8 -*-


from os import path
import sqlite3

fichier_source = "jeux_de_tests/S201_choixsondes_500m.glz"
database = "jeux_de_tests/S201_choixsondes_500m.sqlite3"

def create_database():
    conn = sqlite3.connect(database)
    c = conn.cursor()
    c.execute('CREATE TABLE sonde ( longitude real, latitude real, valeur real)')
    conn.commit()
    conn.close()

def add_values(donnees):
    """ prend une liste de tuple en argument [(-174.7903851,-12.3005098,28.402)]"""
    conn = sqlite3.connect(database)
    c = conn.cursor()
    c.executemany('INSERT INTO sonde VALUES (?,?,?)',donnees)
    conn.commit()
    conn.close()


def recuperer():
    """ prend une liste de tuple en argument [(-174.7903851,-12.3005098,28.402)]"""
    conn = sqlite3.connect(database)
    c = conn.cursor()
    for ligne in c.execute("SELECT valeur FROM sonde WHERE latitude="):
        print(ligne)
    conn.commit()
    conn.close()


def parse_glz(mfile):
    fichierGLZ = open(mfile,'r')
    datas = []
    for line in fichierGLZ.readlines():
        longitude,lat,val = line.split(' ')
        datas.append((longitude,lat,val[:-1:]))
    add_values(datas)
    fichierGLZ.close()

if __name__ == '__main__':
    if not path.isfile(database):
        create_database()
    if path.isfile(fichier_source):
        parse_glz(fichier_source)
    
    