# -*coding: UTF-8 -*-
from threading import Thread, Event
from time import sleep
from sys import stdout

_passage_100M = Event()
_passage_200M = Event()
_passage_300M = Event()
_top_depart = Event()

class Coureur(Thread):
    def __init__(self,speed,eventLaunch=None,eventWait=None):
        Thread.__init__(self)
        self._eventWait = eventWait
        self._eventLaunch = eventLaunch
        self._speed = speed

    def run(self):
        _top_depart.wait()
        if self._eventWait:
            self._eventWait.wait()
        for i in range(10):
            stdout.write('.')
            stdout.flush()
            sleep(self._speed)
        stdout.write('100M fait')
        if self._eventLaunch:
            self._eventLaunch.set()


if __name__=='__main__':
    #on utilise un variable pour attendre le dernier !
    c4 = Coureur(0.5,eventWait=_passage_300M)
    c4.start()
    #premier coureur
    Coureur(0.5,eventLaunch=_passage_100M).start()
    #snd coureur
    Coureur(0.1,eventLaunch=_passage_200M,eventWait=_passage_100M).start()
    Coureur(0.2,eventLaunch=_passage_300M,eventWait=_passage_200M).start()

    print('Pan !')
    _top_depart.set()

    #on attend que le dernier coureur ait terminé
    c4.join()
    print('\nCourse terminée')