# -*coding: UTF-8 -*-
__author__ = 'nicolasperrier'
import random
from threading import Thread
from time import time
from sys import stdout

NB_ITER = 10000
NB_LIST = 1000

def carre(liste):
    return map(lambda a:a**2,liste)


class faireCalcul(Thread):
    def __init__(self,data, results):
        Thread.__init__(self)
        self._data = data
        self._results = results

    def run(self):
        for uneListe in self._data:
            self._results.append(carre(uneListe))


if __name__== '__main__':
    #preparation de la liste des entiers a mettre au carre
    print('Préparation des données')
    listesDonnees = []
    for i in range(NB_ITER):
        listesDonnees.append(tuple(range(0,NB_LIST)))
    print("Données prêtes")

    #methode 1: approche sequentiel
    print('Séquentiel')
    results = []
    now = time()
    for liste in listesDonnees:
        results.append(carre(liste))
    dureeSeq = time()-now
    print (len(listesDonnees)==len(results) and 'Ok') or 'Ko'


    #methode 2: approche parallèle par 2 threads
    print('Par thread')
    results = []
    c1 = faireCalcul(listesDonnees[0:int(NB_ITER/4)], results)
    c2 = faireCalcul(listesDonnees[int(NB_ITER/4):int((NB_ITER*2)/4)], results)
    c3 = faireCalcul(listesDonnees[int((NB_ITER*2)/4):int((NB_ITER*3)/4)], results)
    c4 = faireCalcul(listesDonnees[int((NB_ITER*3)/4):], results)
    now = time()
    #lancement des calculs
    c1.start()
    c2.start()
    c3.start()
    c4.start()
    #on attend la fin des calculs
    c1.join()
    c2.join()
    c3.join()
    c4.join()
    dureeThread = time()-now
    print((len(listesDonnees)==len(results) and 'Ok') or 'Ko')

    print('Ecart temps : plus rapide de %s%%' % str(100-((dureeThread*100)/dureeSeq)))



