from random import randint
liste_mots = (
    "armoire",
    "boucle",
    "buisson",
    "bureau",
    "chaise",
    "carton",
    "couteau",
    "fichier",
    "garage",
    "glace",
    "journal",
    "kiwi",
    "lampe",
    "liste",
    "montagne",
    "remise",
    "sandale",
    "taxi",
    "vampire",
    "volant",
)

class Pendu:
    nb_erreurs:int = 0
    mot:str
    mot_revele:list

    def __init__(self,max_erreurs:int=11):
        self.__max_erreurs = max_erreurs
        global liste_mots
        position = randint(0,len(liste_mots)-1)
        self.mot = liste_mots[position]
        self.mot_revele = list('-'*len(self.mot))

    def demander_lettre(self)->str:
        """

        :return: str, la lettre saisie
        """
        lettre = input('Saisir une lettre:')
        return lettre

    def tester_lettre(self, lettre:str):
        """

        :param lettre:
        :return:
        """
        if lettre in self.mot:
            self.completer_mot(lettre)
        else:
            self.nb_erreurs += 1
            print(f'Nombre erreurs: {self.nb_erreurs}')

    def completer_mot(self,lettre:str)->None:
        """

        :param lettre:
        :return:
        """
        for position_lettre, lettre_mot in enumerate(self.mot):
            if lettre_mot == lettre:
                self.mot_revele[position_lettre] = lettre

    def __str__(self):
        """
        """
        return self.afficher_jeu()

    def __add__(self, other:int):
        self.__max_erreurs += other
    def afficher_jeu(self)->str:
        """

        :return:
        """
        return f"""
Nb erreurs: {self.nb_erreurs} / {self.__max_erreurs}
Mot en cours: {''.join(self.mot_revele)}
"""

    def lancer_partie(self):
        """

        :return:
        """
        condition_perdu = False
        condition_gagne = False
        while not condition_perdu and not condition_gagne:
            print(self.afficher_jeu())
            lettre = self.demander_lettre()
            self.tester_lettre(lettre)
            condition_perdu = self.nb_erreurs == self.__max_erreurs
            condition_gagne = '-' not in self.mot_revele

        if condition_gagne:
            print("Bravo !")
        else:
            print(f"Perdu: {self.mot}")

