"""
Module de définition des outils pour afficher/manipuler des données météo
"""
#liste des imports nécessaires
from requests import get
from bs4 import BeautifulSoup
from matplotlib import pyplot

#cas particulier du réseau ENSIBS: indiquer la porte de sortie
sorties = {'http':'193.52.32.156:3128',
           'https': '193.52.32.156:3128'}
#Pour simuler un navigateur dans l'entête HTTP
entetes_http = {'user-agent':'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:124.0) Gecko/20100101 Firefox/124.0'}

def recuperer_meteo_xml(latitude:float, longitude:float, alt:int)->str:
    """
    Fonction pour récupérer la météo d'un point GPS, et son altitude
    En entrée: 
    - latitude, type float
    - longitude, type float
    - alt, type int
    Sortie:
    - le fichier xml, type str
    """
    #consturction de l'url pour l'appel météo
    url = f"https://api.met.no/weatherapi/locationforecast/2.0/classic?lat={latitude}&lon={longitude}&altitude={alt}"
    #lancement de l'appel via une action GET, protocole HTTP
    contenu_xml = get(url, headers=entetes_http)#,proxies=sorties)
    #on retourne le contenu de la réponse. Le corps contient le contenu XML
    return contenu_xml.text


def recuperer_serie_donnees(contenu_xml:str)->tuple[list[str],list[float]]:
    """
    Fonction pour récupérer la serie de température issue des données XML
    En entrée: 
    - le contenu xml des données météos, type str
    Sortie:
    - la liste des dates et temperatures, type tuple
    """
    #création du parseur XML
    parseur_xml = BeautifulSoup(contenu_xml)
    #pour stocker les températures récupérées
    temperatures = []
    #la date pour chaque température
    dates = []
    #parcours dans l'arborescence XML de toutes les balises time
    for balise_time in parseur_xml.find_all('time'):
        #au sein de la balise time, récupération de toutes les balises temperature
        for balise_temp in balise_time.find_all('temperature'):
            #récupération de la valeur de cette balise température
            temp = balise_temp.get('value')
            #passage en float et stockage
            temperatures.append(float(temp))
            #récupération de la date, et stockage
            date = balise_time.get('from')
            dates.append(date)
    #nous renvoyons la liste
    return (dates, temperatures)

def afficher_temperatures(les_tempe:list[float], les_dates:list[str])->None:
    """
    Fonction pour afficher la serie de température issue des données XML
    En entrée: 
    - la liste des températures à afficher, type list de float
    - la liste des dates associées, type liste de str
    Sortie:
    - Rien
    """
    #création d'un figure
    fig, graphe = pyplot.subplots()
    #ajout des points dans la figure
    graphe.plot(les_dates,les_tempe)
    #affichage de la figure
    pyplot.show()

if __name__ == "__main__":
    #programme principal, en 3 étapes:
    #récupération de la météo en XML
    xml = recuperer_meteo_xml(47.75, -3.36667, 5)
    #récupération des dates et températures
    donnees = recuperer_serie_donnees(xml)
    #récupération des dates
    dates = donnees[0]
    #récupération des dates
    temperatures = donnees[1]
    #affichage des températures
    afficher_temperatures(temperatures, dates)