"""
module de définition de la classe pendu
"""
#imports nécessaires au bon fonctionnement
from random import choice
from string import ascii_lowercase
#liste de mots; TODO: chargement les mots depuis un fichier ?
liste_mots = [
    "armoire",
    "boucle",
    "buisson",
    "bureau",
    "chaise",
    "carton",
    "couteau",
    "fichier",
    "garage",
    "glace",
    "journal",
    "kiwi",
    "lampe",
    "liste",
    "montagne",
    "remise",
    "sandale",
    "taxi",
    "vampire",
    "volant",
]
#création de la classe pour gérer le jeu
class Pendu:
    """
    classe pour gérer une partie de pendu
    """
    #constructeur: permettre la création d'une partie avec un nombre d'erreurs max
    def __init__(self, nb_erreurs_max:int)->None:
        """
        constructure du jeu
        En entrée:
        - nombre d'erreurs max, type int
        """
        #stockage de l'information via une propriété: elle devient accessible dans toutes les méthodes
        self.nb_erreurs_mx = nb_erreurs_max

    def __afficher(self)->None:
        """
        méthode de l'affichage de l'état du jeu, à appeler dès que nécessaire
        """
        #affichage du mot en cours (reconstitution de la chaine à partir de la liste des lettres)
        print(''.join(self.mot_secret))
        #affichage des erreurs restantes
        print(f"Erreurs restantes: {self.nb_erreurs_mx}")

    def __controler_saisie(self, lettre:str)->bool:
        """
        méthode pour contrôler les erreurs de saisie
        En entrée:
        - la saisie utilisateur, type str
        En sortie:
        - vrai/faux, type bool
        """
        #mise en place du flag: la saisie est par défaut bonne !
        ok = True
        #premier cas: trop de caractères saisis
        if len(lettre)!=1:
            ok = False
            print('Trop de lettres')
        #second cas: caractère n'est pas une lettre 
        elif not lettre in ascii_lowercase:
            ok = False
            print(f"{lettre} n'est une lettre alphabet")
        #troisième cas: lettre déjà saisie
        elif lettre in self.lettres_saisies:
            ok = False
            print(f'{lettre} déjà saisie ! ')
        #renvoie du flag: si aucun cas n'est vrai, le flag reste vrai
        return ok
    
    def lancer(self)->None:
        """
        Méthode pour lancer une nouvelle partie
        """
        #choix alétoire du mot dans la liste
        mot = choice(liste_mots)
        #création du mot secret, via une liste contenant autant de "_" que de lettre
        #rattachement à une propriété pour usage dans les autres méthodes
        self.mot_secret = list('_' * len(mot))
        #la liste des lettres déjà saisies; rattachement à une propriété pour usage dans les autres méthodes
        self.lettres_saisies = []
        #flag de fin de partie
        perdu = False
        gagne = False
        #tant que la partie n'est pas terminée
        while not gagne and not perdu:
            #saisie d'une lettre
            lettre = input('Saisir une lettre: ')
            #passage en minuscule
            lettre = lettre.lower()
            #contrôle de la saisie
            if not self.__controler_saisie(lettre):
                #couac... une erreur
                self.nb_erreurs_mx = self.nb_erreurs_mx - 1
                #on repart direct vers le tour suivant
                continue
            #tout est ok pour la saisie, ajout de la lettre
            self.lettres_saisies.append(lettre)
            #est ce une bonne lettre ?
            if lettre in mot:
                #oui, trouvons les positions dans le mot à découvrir
                for position,lettre_mot in enumerate(mot):
                    #bonne position ? Oui, alors on remplace dans le mot secret qui se dévoile
                    if lettre_mot == lettre:
                        self.mot_secret[position] = lettre
            else:
                #mauvais choix: application d'une erreur
                print(f"Mauvaise pioche avec {lettre}")
                self.nb_erreurs_mx = self.nb_erreurs_mx - 1
            #on fait l'affichage pour donner de la visibilité à l'utilisateur
            self.__afficher()
            #on vérifie les cas de fin de partie
            #nombre d'erreurs max atteint
            if self.nb_erreurs_mx  == 0:
                perdu = True
                print('Perdu !')
            #ou mot trouvé !
            if '_' not in self.mot_secret:
                gagne = True
                print('Bravo !')


