"""
Module de définition de l'interface graphique tkinter pour le codage/décodage cesar
"""
#liste des imports nécessaires
from tkinter import Button,Tk, Frame, Entry, Text, END
from tkinter.filedialog import askopenfilename
from outils.codage_cesar import coder_cesar, decoder_cesar

class IHMCesar:
    """
    Définition de la classe pour créer l'IHM
    """
    def __init__(self, fenetre_p:Tk) -> None:
        """
        Le constructeur. Il permet de déployer toute l'interface graphique
        En entrée: 
        - la fenêtre principale, type Tk
        Sortie:
        - None
        """
        #création d'une zone en haut, pour positionner correctement les boutons/entry VS la zone de texte
        haut = Frame(fenetre_p)
        #affichage en mode pack
        haut.pack()
        #création du bouton pour permettre de choisir le fichier à traiter
        b = Button(haut, text="?", command=self.choisir_fichier)
        #passage en mode grid pour les widgets de cette frame
        b.grid(row=0, column=1)

        #création de la zone de saisie pour l'utilisateur: ce sera le chemin choisi
        self.zone_saisie = Entry(haut)
        self.zone_saisie.grid(row=0, column=0)

        #création du bouton d'action, ici coder
        b_coder = Button(haut, text="Coder", command=self.coder)
        b_coder.grid(row=1, column=0)

        #création du bouton d'action, ici décoder
        b_coder = Button(haut, text="Décoder", command=self.decoder)
        b_coder.grid(row=1, column=1)

        #affichage d'une zone de texte pour l'affichage du texte traité
        self.affichage = Text(fenetre_p)
        self.affichage.pack()

        #lancement de l'interface graphique: tout est prêt !
        fenetre_p.mainloop()

    def coder(self)->None:
        """
        Méthode pour coder le fichier dont nous avons obtenu l'emplacement
        et sauver le résultat dans le même fichier
        En entrée: 
        - self, l'IHM
        Sortie:
        - None
        """
        #récupération du message, fonction coder
        message_code = coder_cesar(self.zone_saisie.get(),
                                   self.zone_saisie.get()
                                   )
        #ajout dans la zone d'affichage
        self.affichage.insert(END, message_code)

    def decoder(self):
        """
        Méthode pour décoder le fichier dont nous avons obtenu l'emplacement
        et sauver le résultat dans le même fichier
        En entrée: 
        - self, l'IHM
        Sortie:
        - None
        """
        #récupération du message, fonction décoder
        message_code = coder_cesar(self.zone_saisie.get(),
                                   self.zone_saisie.get()
                                   )
        #ajout dans la zone d'affichage
        self.affichage.insert(END, message_code)

    def choisir_fichier(self):
        """
        Méthode pour récupérer l'emplacement du fichier
        En entrée: 
        - self, l'IHM
        Sortie:
        - None
        """
        #interrogation de l'utilisateur: quel emplacement ?
        chemin = askopenfilename()
        #on ajoute cet emplacement dans la zone de saisie (avec nettoyage préalable)
        self.zone_saisie.delete(0,END)
        self.zone_saisie.insert(0,chemin)