"""
Module définissant les outils pour le codage/decodage cesar
"""
#liste des imports nécessaires
from string import ascii_letters

def coder_cesar(mon_fichier:str, fichier_sortie:str)->str:
    """
    Fonction pour coder
    En entrée: 
    - emplacement du fichier, type str
    - emplacement du fichier à coder, type str
    Sortie:
    le message codé, type str
    """
    #appel de la transformé de cesar avec les bons paramètres en entrée
    return __transformer_cesar(mon_fichier, 13, fichier_sortie)

def decoder_cesar(mon_fichier:str, fichier_sortie:str)->str:
    """
    Fonction pour décoder
    En entrée: 
    - emplacement du fichier, type str
    - emplacement du fichier à décoder, type str
    Sortie:
    le message décodé, type str
    """
    #appel de la transformé de cesar avec les bons paramètres en entrée
    return __transformer_cesar(mon_fichier, -13, fichier_sortie)

def __transformer_cesar(nom_fichier:str, decalage:int, f_sortie:str)->str:
    """
    Fonction centrale, privée pour coder/décoder façon César
    En entrée: 
    - emplacement du fichier, type str
    - décalage à appliquer, type int
    - emplacement du fichier à décoder, type str
    Sortie:
    le message décodé, type str
    """
    #ouverture du fichier en lecture, avec passage de l'encoding pour ceintures et bretelles
    with open(nom_fichier,'r', encoding="UTF-8") as lire_fichier:
        #lecture du contenu, chargement dans une variable (format str)
        contenu = lire_fichier.read()
    #liste vide pour stocker les caractères traités
    nx_caracteres = []
    #pour chaque caractère du message
    for caractere in contenu:
        #est ce un caractère à traiter,ie, une lettre ?
        if caractere in ascii_letters:
            #oui, déterminons la position dans l'alphabet
            position = ascii_letters.find(caractere)
            #avec le décalage, trouvons la nouvelle position
            nouvelle_position = (position + decalage) % len(ascii_letters)
            #pour cette position, quelle lettre ?
            nouvelle_lettre = ascii_letters[nouvelle_position]
            #stockage dans la liste
            nx_caracteres.append(nouvelle_lettre)
        else:
            #aucun traitement, nous stockons normalement
            nx_caracteres.append(caractere)
    #on reconstitue la chaine de caractères traitée à partir de la liste
    contenu_traite = ''.join(nx_caracteres)
    #ouverture du fichier en écriture, encoding utf-8
    with open(f_sortie,'w',encoding="UTF-8") as fichier_ecrire:
        #ecriture du nouveau message
        fichier_ecrire.write(contenu_traite)
    #on renvoie le contenu obtenu
    return contenu_traite

