"""
module de définition de la classe pendu
"""
#imports nécessaires au bon fonctionnement
from random import choice
from string import ascii_lowercase
#liste de mots; TODO: chargement les mots depuis un fichier ?
liste_mots = [
    "armoire",
    "boucle",
    "buisson",
    "bureau",
    "chaise",
    "carton",
    "couteau",
    "fichier",
    "garage",
    "glace",
    "journal",
    "kiwi",
    "lampe",
    "liste",
    "montagne",
    "remise",
    "sandale",
    "taxi",
    "vampire",
    "volant",
]
#création de la classe pour gérer le jeu
class Pendu:
    """
    classe pour gérer une partie de pendu
    """
    #constructeur: permettre la création d'une partie avec un nombre d'erreurs max
    def __init__(self, nb_erreurs_max:int)->None:
        """
        constructure du jeu
        En entrée:
        - nombre d'erreurs max, type int
        """
        #stockage de l'information via une propriété: elle devient accessible dans toutes les méthodes
        self.nb_erreurs_mx = nb_erreurs_max

    def __affichage(self)->None:
        """
        méthode de l'affichage de l'état du jeu, à appeler dès que nécessaire
        """
        #affichage du mot en cours (reconstitution de la chaine à partir de la liste des lettres)
        print(self.mot_en_cours)
        #affichage des erreurs restantes
        print("Nombre erreurs: {}/{}".format(self.erreur_utilisateur, self.nb_erreurs_mx))
 
    def lancer(self)->None:
        """
        Méthode pour lancer une nouvelle partie
        """
        #choix alétoire du mot dans la liste
        mot = choice(liste_mots)
        #création du mot en cours, via une liste contenant autant de "_" que de lettre
        #rattachement à une propriété pour usage dans les autres méthodes
        self.mot_en_cours = list('_' * len(mot))
        #la liste des lettres déjà saisies;
        lettre_saisie = []
        #nombre d'erreurs de l'utilisateur
        self.erreur_utilisateur = 0
        #flag de fin de partie
        gagne = False
        perdu = False
        #tant que la partie n'est pas terminée
        while not gagne and not perdu:
            #saisie d'une lettre
            lettre = input("Saisir une lettre : ")
            #contrôle de la saisie
            #premier cas: lettre déjà connue
            if lettre in lettre_saisie:
                #affichage
                print(f"Lettre déjà saisie {lettre}")
                #et une erreur !
                self.erreur_utilisateur = self.erreur_utilisateur + 1
            #second cas: trop de lettres !
            elif len(lettre)!=1:
                #affichage
                print('Retire tes moufles, une lettre seulement')
                #et une erreur
                self.erreur_utilisateur = self.erreur_utilisateur + 1
            #troisième cas: caractère n'est pas une lettre !
            elif lettre not in ascii_lowercase:
                #affichage...
                print(f"Ce n'est pas une lettre: {lettre}")
                #et une erreur (la vie est dure...)
                self.erreur_utilisateur = self.erreur_utilisateur + 1
            else:
                #tout est ok pour la saisie, ajout de la lettre
                lettre_saisie.append(lettre)
                #est ce une bonne lettre ?
                if lettre not in mot:
                    #mauvais choix: application d'une erreur
                    self.erreur_utilisateur = self.erreur_utilisateur + 1
                    print("Mauvaise pioche !")
                else:
                    #oui, trouvons les positions dans le mot à découvrir
                    for indice,lettre_mot in enumerate(mot):
                        #bonne position ? Oui, alors on remplace dans le mot secret qui se dévoile
                        if lettre_mot == lettre:
                            self.mot_en_cours[indice] = lettre
                    print("bon choix !")
                #on fait l'affichage pour donner de la visibilité à l'utilisateur
                self.__affichage()
            #on vérifie les cas de fin de partie
            #mot trouvé !
            if '_' not in self.mot_en_cours:
                gagne = True
                print("Gagné !")
            #ou nombre d'erreurs max atteint
            elif self.nb_erreurs_mx<=self.erreur_utilisateur:
                perdu = True
                print("Perdu !")



    
