"""
Module de définition des outils pour afficher/manipuler des données météo
"""
#liste des imports nécessaires
from requests import get
from bs4 import BeautifulSoup
from matplotlib import pyplot

#cas particulier du réseau ENSIBS: indiquer la porte de sortie
sorties = {'http':'193.52.32.156:3128',
           'https':'193.52.32.156:3128'}

#Pour simuler un navigateur dans l'entête HTTP
entete_http = {'user-agent':"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:124.0) Gecko/20100101 Firefox/124.0"}

def recuperer_xml(latitude:float, longitude:float, altitude:int)->str:
    """
    Fonction pour récupérer la météo d'un point GPS, et son altitude
    En entrée: 
    - latitude, type float
    - longitude, type float
    - altitude, type int
    Sortie:
    - le fichier xml, type str
    """
    #consturction de l'url pour l'appel météo
    url = f'https://api.met.no/weatherapi/locationforecast/2.0/classic?lat={latitude}&lon={longitude}&altitude={altitude}'
    #lancement de l'appel via une action GET, protocole HTTP
    retour_web = get(url,headers=entete_http)#, proxies=sorties,) 
    #on retourne le contenu de la réponse. Le corps contient le contenu XML
    return retour_web.text

def recuperer_serie_donnees(contenu_xml:str)->list[float]:
    """
    Fonction pour récupérer la serie de température issue des données XML
    En entrée: 
    - le contenu xml des données météos, type str
    Sortie:
    - la liste des temperatures, type list[float]
    """
    #pour stocker les températures récupérées
    temperatures = []
    #création du parseur XML
    parseur_xml = BeautifulSoup(contenu_xml)
    #parcours dans l'arborescence XML de toutes les balises time
    for balise_time in parseur_xml.find_all('time'):
        #au sein de la balise time, récupération de toutes les balises temperature
        for balise_temp in balise_time.find_all('temperature'):
            #récupération de la valeur de cette balise température
            temp = balise_temp.get('value')
            #passage en float
            temp = float(temp)
            #ajout à la liste
            temperatures.append(temp)
    #nous renvoyons la liste
    return temperatures

def afficher_graphe(liste_temperatures:list[float])->None:
    """
    Fonction afficher la serie de température issue des données XML
    En entrée: 
    - la liste des températures à afficher, type list de float
    Sortie:
    - Rien
    """
    #création d'un figure
    fig, graphe = pyplot.subplots()
    #ajout des points dans la figure
    graphe.plot(liste_temperatures)
    #affichage de la figure
    pyplot.show()


if __name__ == "__main__":
    #programme principal, en 3 étapes:
    #récupération de la météo en XML
    xml = recuperer_xml(47.75, -3.36667, 5)
    #récupération des températures
    liste_temp = recuperer_serie_donnees(xml)
    #affichage des températures
    afficher_graphe(liste_temp)