"""
Module définissant les outils pour le codage/decodage cesar
"""
#liste des imports nécessaires
from string import ascii_letters
from os.path import isfile

def coder_cesar(mon_fichier:str)->str:
    """
    Fonction pour coder
    En entrée: 
    - emplacement du fichier, type str
    Sortie:
    le message codé, type str
    """
    #appel de la transformé de cesar avec les bons paramètres en entrée
    return __transformer_cesar(mon_fichier, 13)

def decoder_cesar(mon_fichier:str)->str:
    """
    Fonction pour décoder
    En entrée: 
    - emplacement du fichier, type str
    Sortie:
    le message décodé, type str
    """
    #appel de la transformé de cesar avec les bons paramètres en entrée
    return __transformer_cesar(mon_fichier, -13)

def __transformer_cesar(nom_fichier:str,decalage:int)->str:
    """
    Fonction centrale, privée pour coder/décoder façon César
    En entrée: 
    - emplacement du fichier, type str
    - décalage à appliquer, type int
    Sortie:
    le message décodé, type str
    """
    #le fichier existe ?
    if isfile(nom_fichier):
        #oui, alors on le lit: 
        #ouverture du fichier en lecture, avec passage de l'encoding pour ceintures et bretelles
        with open(nom_fichier,'r') as fichier_lire:
            #chargement dans une variable (format str)
            contenu = fichier_lire.read()
    else:
        #non... alors on considère que c'est un message direct
        contenu = nom_fichier
    
    #liste vide pour stocker les caractères traités
    nx_message = []
    #pour chaque caractère du message
    for caractere in contenu:
        #est ce un caractère à traiter,ie, une lettre ?
        if caractere in ascii_letters:
            #oui, déterminons la position dans l'alphabet
            position_car = ascii_letters.find(caractere)
            #avec le décalage, trouvons la nouvelle position
            nx_position_car = (position_car + decalage) % len(ascii_letters)
            #pour cette position, quelle lettre ?
            nx_lettre = ascii_letters[nx_position_car]
            #stockage dans la liste
            nx_message.append(nx_lettre)
        else:
            #aucun traitement, nous stockons normalement
            nx_message.append(caractere)

    #on reconstitue la chaine de caractères traitée à partir de la liste
    return ''.join(nx_message)

