"""
Module pour les premiers exercices
"""
#imports nécessaires
from string import ascii_lowercase
from unicodedata import normalize

if __name__=='__main__':
    #exercice : sortir la liste des nombres impairs
    liste = [4, 8, 5, 36, 78, 0, -5, 3, -10]
    #affichage de la liste initiale
    print(liste)
    #création d'une liste vide, qui va stocker les bonnes valeurs
    liste_impairs = []#list()
    #pour chaque nombre de la liste initiale
    for un_nombre in liste:
        #est ce un nombre impair, ie, si cela rend 1, c'est vrai
        if un_nombre % 2:
            #j'ajoute le nombre dans la liste
            liste_impairs.append(un_nombre)
    #affichage du résultat
    print(liste_impairs)

    #exercice : sortir la liste des nombres impairs (par liste de comprehension)
    #rapide en saisie, mais pas forcément plus efficace !!
    liste_impairs = [un_nombre for un_nombre in liste if un_nombre % 2]
    print(liste_impairs)

    #exercice : afficher toutes les tables de multiplication
    valeurs = range(0,11)
    #création d'un modèle à exploiter à chaque print (éviter des créer des modèles à chaque tour !)
    modele = "Table de {} :"
    #pour les 10 tables
    for table in valeurs:
        #affichage du nom de la table
        print(modele.format(table))
        #pour chaque ligne de la table
        for ligne_table in valeurs:
            #affichage de la ligne de la table
            print(f"{table} X {ligne_table} = {table*ligne_table}")


    #exercice : afficher les phrases qui sont des hétérogrammes (une lettre présent au max 1 fois)
    phrases = ['Lampez un fort whisky',
             'The quick brown fox jumps over the lazy dog',
             "Plombez vingt fuyards",
             "The big dwarf only jumps",
             "Allons enfants de la patrie",
             "Tu l'as trop ecrase cesar ton port salut"
             ]
    #pour chaque phrase
    for phrase in phrases:
        #mise en place d'un flag: par défaut, cela marche
        phrase_ok = True
        #passage en minuscule
        phrase_min = phrase.lower()
        #normalisation (retrait des accents)
        phrase_min = normalize('NFD',phrase_min)
        #on passe en revue chaque lettre
        for lettre in ascii_lowercase:
            #comptabilisation ?
            presence = phrase_min.count(lettre)
            #c'est un cas d'exclusion... flag à faux
            if presence>1:
                phrase_ok = False
                #on sort de la boucle: pas besoin d'aller plus loin
                break
        #quel est l'état du flag ?
        if phrase_ok:
            #aucun cas d'exclusion rencontré... on affichage la phrase
            print(phrase)    



    #exercice : afficher les phrases qui sont des pangrammes (toutes les lettres de l'alphabet (au moins 1 fois))
    phrases = ['Portez ce vieux whisky au juge blond qui fume',
             'The quick brown fox jumps over the lazy dog',
             "Voix ambiguë d'un coeur qui au zéphyr préfère les jattes de kiwis",
             "Vif juge, trempez ce blond whisky aqueux",
             "Fripon, mixez l'abject whisky qui vidange",
             "Prouvez, juge, que le fameux sandwich au yak tue",
             "Buvez de ce bourbon que le patron juge fameux",
             "Voyez le brick énorme que j'examine près du wharf"
             ]

    #pour chaque phrase
    for phrase in phrases:
        #mise en place d'un flag: par défaut, cela marche
        phrase_ok = True
        #passage en minuscule
        phrase_min = phrase.lower()
        #normalisation (retrait des accents)
        phrase_min = normalize('NFD',phrase_min)
        #on passe en revue chaque lettre
        for lettre in ascii_lowercase:
            #comptabilisation ?
            presence = phrase_min.count(lettre)
            #c'est un cas d'exclusion... flag à faux
            if not presence:
                phrase_ok = False
                #on sort de la boucle: pas besoin d'aller plus loin
                break
        #quel est l'état du flag ?
        if phrase_ok:
            #aucun cas d'exclusion rencontré... on affichage la phrase
            print(phrase)   

    #exercice : dire quels sont les palindromes dans la liste de mots
    mots = ['radar',
             'kayak',
             'voiture',
             "Ressasser",
             "1234+8765=9999=5678+4321",
             ]
    #pour chaque mot
    for mot in mots:
        #passage en minuscule
        mot_min = mot.lower()
        #on inverse le mot, est ce le même ?
        if mot_min == mot_min[::-1]:
            #oui, on peut l'afficher
            print(mot)
    #autre approche: pour chaque mot
    for mot in mots:
        #passage en minuscule
        mot_min = mot.lower()
        #passage par une liste
        mot_liste = list(mot_min)
        #on inverse cette liste
        mot_liste.reverse()
        #est ce que le mot est le même que la liste inversée, reconstruite en chaine de caractères ?
        if mot_min == ''.join(mot_liste):
            print(mot)
    #exercice : trier les planetes par la taille de leur rayon
    Venus = {'rayon' : 6051, 'nom':'Venus'}
    Mercure = {'rayon' : 2439,'nom' : 'Mercure'}
    Terre = {'rayon' : 6378, 'nom':'Terre'}
    Pluton = {'nom':'Pluton'}
    planetes = [Venus, Mercure, Terre,Pluton]
    #TypeError: '<' not supported between instances of 'dict' and 'dict'

    def recuperer_rayon(une_planete:dict)->int:
        """
        fonction qui permet de renvoyer le rayon
        En entrée:
        - une planète, type dict
        En sortir:
        - le rayon, type int (0 par défaut)
        """
        #pour le dictionnaire, récupération de la valeur derrière la clé rayon
        rayon = une_planete.get('rayon',0)
        #on envoie en sortie le rayon
        return rayon
    
    #un test sur 1 planère
    rayon_venus = recuperer_rayon(Venus)
    #on indique à python la fonction à utiliser pour avoir les clés de tri (ie, les rayons)
    planetes.sort(key=recuperer_rayon, reverse=True)
    #contrôle: est ce trié, en inverse ? 
    print(planetes)
