"""
Module de définition du serveur WEB
"""
#liste des imports nécessaires
from flask import Flask, render_template, request, make_response, redirect
from os.path import join
from ultralytics import Yolo
from PIL import Image
from numpy import asarray

#création du serveur WEB, avec son nom
application_web = Flask('test_image')
#définition de paramètres: ici l'emplacement de stockage des fichiers téléversés
application_web.config['UPLOAD_FOLDER'] = join('staticfiles','uploads')

#route/url pour la page d'accueil
@application_web.route('/', methods=['GET'])
def page_accueil():
    """
    Fonction générer le contenu HTML de la page d'accueil
    En entrée: 
    - Rien
    Sortie:
    le template HTML construit
    """
    #récupératin du nom de l'utilisateur
    nom = request.cookies.get('nom','')
    #je construis le template en passant les informations récoltées
    #et le renvoie
    return render_template('application.html', nom_utilisateur=nom)

#route/url pour simuler la deconnexion
@application_web.route('/deconnecter',methods=['GET'])
def deconnecter_utilisateur():
    """
    Fonction pour supprimer le cookie
    En entrée: 
    - Rien
    Sortie:
    une réponse correspondant à redirection vers la page d'accueil
    """
    #création de la réponse
    reponse = make_response(redirect('/'))
    #suppression du cookie (limite d'age à 0)
    reponse.set_cookie('nom', max_age=0)
    #renvoi de la réponse
    return reponse

#route/url pour gérer le traitement
@application_web.route('/traiter_image', methods=['POST'])
def traitement():
    """
    Fonction pour récupérer l'image, et l'analyser
    En entrée: 
    - Rien
    Sortie:
    une réponse correspondant à une redirection vers la page d'accueil avec un message contenant les éléments anaylisés 
    par l'IA
    """
    #récupération de l'image envoyée par le formulaire
    fichier_image = request.files.get('image_yolo')
    #construction d'un chemin où stocker l'image
    fichier_image.save(join(application_web.config['UPLOAD_FOLDER'], fichier_image.filename))
    #chargement du modèle entrainé V8N
    model = Yolo("yolov8n.pt")
    #création d'une image au format PIL, objet pour manipuler des images via python
    image_pil = Image.open(join(application_web.config['UPLOAD_FOLDER'], fichier_image.filename))
    #transformation de l'image en matrice
    image_matrice = asarray(image_pil)
    #analyse de l'image par le modèle de prédiction
    retour_ia= model.predict(image_matrice)
    #pour chaque type trouvé
    for element in retour_ia:
        #pour chaque zone dans l'image du type trouvé
        for zone in element.boxes:
            #la classe du type d'objet trouvé
            objet_trouve = zone.cls[0].item()
            #afficher le nom "humain" pour cette classe
            print(element.names[objet_trouve])
    #on créé la réponse
    reponse = make_response(redirect('/'))
    #et retour à l'accueil
    return reponse

#route/url pour simuler la connexion d'un utilisateur
@application_web.route('/connecter', methods=['POST'])
def connecter_utilisateur():
    """
    Fonction pour générer un cookie contenant le nom de l'utilisateur passé dans le formulaire
    En entrée: 
    - Rien
    Sortie:
    une réponse correspondant à redirection vers la page d'accueil
    """
    #récupération du nom de l'utilisateur passé via le formulaire
    nom = request.form.get('nom_utilisateur')
    #création de la réponse
    reponse = make_response(redirect('/'))
    #ajout du cookie
    reponse.set_cookie('nom', nom)
    #renvoie de la reponse
    return reponse


if __name__ == "__main__":
    #programme principal: on lance le serveur web !
    application_web.run()