"""
Module de définition des outils pour les données de répartition des sols
"""
#liste des imports nécessaires
from requests import get
from json import loads
from csv import reader
from sqlite3 import connect
from matplotlib import pyplot

#cas particulier du réseau ENSIBS: indiquer la porte de sortie
porte_sortie_ensibs = {'http':'193.52.32.156:3128',
           'https':'193.52.32.156:3128'
           }

def recuperer_code_insee(nom_commune:str)->int:
    """
    Fonction pour récupérer le code insee à partir d'un  nom de commune
    En entrée: 
    - nom de la commune recherchée, type str
    Sortie:
    le code insee, type int, 0 si non trouvé
    """
    #construction de l'url de recherche
    url = f"https://public.opendatasoft.com/api/explore/v2.1/catalog/datasets/correspondance-code-cedex-code-insee/records?where=libelle%20like%20%27{nom_commune}%27&limit=20"
    #lancement de l'appel via une action GET, protocole HTTP
    contenu_api = get(url)#proxies=porte_sortie_ensibs
    #récupération du contenu de l'API, au format texte puis chargement JSON
    contenu_json = loads(contenu_api.text)
    #récupération de l'entrée results dans le dictionnaire obtenu
    resultats = contenu_json.get('results',[])
    #par défaut...
    code_insee = 0
    #un résultat ?
    if len(resultats)!=0:
        #oui, alors prenons le premier
        commune = resultats[0]
        #nous devons obtenir le code insee dans le dictionnaire des informations de la commune obtenue
        code_insee = commune.get('insee')
    #nous renvoyons l'information trouvée, ou celle par défaut
    return code_insee

def convertir_csv_vers_sql()->None:
    """
    Fonction pour convertir le BDD Corine Lander (CSV) en SQL
    A appeler une seule fois !
    En entrée: 
    - Rien
    Sortie:
    Rien
    """
    #création d'un liste pour le stockage des lignes correctes
    lignes = []
    #ouverture du fichier CSV, qui doit être à la racine du projet
    with open('clc_etat_com_n1.csv','r', encoding="UTF-8") as fichier_csv:
        #création d'un parseur CSV
        lecture_csv = reader(fichier_csv, delimiter=";")
        #parcours du CSV
        for ligne in lecture_csv:
            #contrôle: est ce une bonne ligne ?
            if ligne and ligne[0].isdigit():
                #oui, alors je retire la colonne du nom de la base qui ne m'intéresse pas
                ligne.pop(2)
                #ajout de toutes les autres colonnes dans le stockage des lignes
                lignes.append(ligne)
    #a ce stade, j'ai en mémoire toutes les répartitions connues
    #création de la base de données
    #attention: si le fichier existe déjà, le code plante lors de la création de la table!
    ma_bdd = connect('bdd_repartition.sql3')
    #création du curseur pour intéraction avec la BDD
    curseur = ma_bdd.cursor()
    #création de la requete SQL pour créer la table des répartitions
    curseur.execute("CREATE TABLE repartitions (code_insee numeric, annee numeric, cl1 real, cl2 real, cl3 real, cl4 real, cl5 real)")
    #injection de toutes les répartitions dans la table SQL
    curseur.executemany("INSERT INTO repartitions VALUES (?,?,?,?,?,?,?)", lignes)
    #validation des commandes SQL
    ma_bdd.commit()
    #fermeture de la base
    ma_bdd.close()

def afficher_repartition(code_insee:int)->None:
    """
    Fonction afficher la répartition des sols d'une commune via une image png !
    En entrée: 
    - le code insee de la commune, type int
    Sortie:
    Rien
    """
    #connexion à la base de données
    with connect('bdd_repartition.sql3') as ma_bdd:
        #création du curseur pour la lecture
        curseur = ma_bdd.cursor()
        #requete SQL pour récupérer la répartition d'une commune
        lignes = curseur.execute(f"SELECT * FROM repartitions WHERE code_insee = {code_insee}")
        #chargement en mémoire du résultat
        lignes = lignes.fetchall()
        #création d'un figure, avec autant de graphes que de lignes (ie, d'année)
        fig, graphes = pyplot.subplots(nrows=len(lignes))
        #pour chaque ligne, ie, année
        for position, ligne in enumerate(lignes):
            #titre du graphe
            titre = "Année {}".format(ligne[1])
            #liste des valeurs
            valeurs = ligne[2:]
            #légendes
            etiquettes = ('I','II','III','IV','V') 
            #petit écart entre chaque tranche
            ecart = (0.1,0.1,0.1,0.1,0.1)
            #création du graphique
            graphes[position].pie(valeurs, explode=ecart, labels = etiquettes)
            #positionnement du titre
            graphes[position].set_title(titre, fontsize=4)
        #affichage de la figure
        pyplot.show()

if __name__ == "__main__":
    #programme principal, en 3 étapes:
    #récupération du nom de la ville
    nom_ville = input("Saisie la ville: ")
    #récupération de son code insee
    code_insee = recuperer_code_insee(nom_ville)
    #ici, à faire 1 seule fois; code optimisable !
    #convertir_csv_vers_sql()
    #obtenir le rendu
    afficher_repartition(int(code_insee))