"""
Module de définition des outils pour afficher/manipuler des données météo
"""
#liste des imports nécessaires
from requests import get
from bs4 import BeautifulSoup
from matplotlib import pyplot

#cas particulier du réseau ENSIBS: indiquer la porte de sortie
porte_sortie_ensibs = {'http':'193.52.32.156:3128',
           'https':'193.52.32.156:3128'
           }
#Pour simuler un navigateur dans l'entête HTTP
headers = {'user-agent':'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:124.0) Gecko/20100101 Firefox/124.0'}

def recuperer_meteo(lat:float,long:float, alt:int)->str:
    """
    Fonction pour récupérer la météo d'un point GPS, et son altitude
    En entrée: 
    - lat, type float
    - long, type float
    - alt, type int
    Sortie:
    - le fichier xml, type str
    """
    #consturction de l'url pour l'appel météo
    url = f'https://api.met.no/weatherapi/locationforecast/2.0/classic?lat={lat}&lon={long}&altitude={alt}'
    #par défaut, chaine vide
    fichier_xml = ""
    try:
        #lancement de l'appel via une action GET, protocole HTTP
        page_xml = get(url,headers=headers)#proxies=porte_sortie_ensibs
        #on retourne le contenu de la réponse. Le corps contient le contenu XML
        fichier_xml =  page_xml.text
    except Exception as erreur:
        #récupération de l'erreur
        print("Erreur http: {}".format(erreur)) 
    return fichier_xml

def recuperer_serie(contenu_xml:str)->list:
    """
    Fonction pour récupérer la serie de température issue des données XML
    En entrée: 
    - le contenu xml des données météos, type str
    Sortie:
    - la liste des temperatures, type list[float]
    """
    #création du parseur XML
    parser = BeautifulSoup(contenu_xml)
    #pour stocker les températures récupérées
    temperatures = []
    #pour stocker les dates
    dates = []
    #parcours dans l'arborescence XML de toutes les balises time
    for balise_time in parser.find_all('time'):
        #récupération de la date
        date_valeur = balise_time.get('from')
        #au sein de la balise time, récupération de toutes les balises temperature
        for balise_temp in balise_time.find_all('temperature'):
            #récupération de la valeur de cette balise température, passage en float
            temperature = float(balise_temp.get("value"))
            #ajout à la liste des temperatures
            temperatures.append(temperature)
            #ajout à la liste des dates
            dates.append(date_valeur)
    #nous renvoyons les 2 series de données
    return temperatures, dates

def afficher_temp(serie_temp:list, dates:list)->None:
    """
    Fonction pour afficher la serie de température issue des données XML
    En entrée: 
    - la liste des températures à afficher, type list de float
    - la liste des dates à afficher, type list de str
    Sortie:
    - Rien
    """
    #création d'un figure
    fig, graphes = pyplot.subplots()
    #ajout des points dans la figure
    graphes.plot(dates, serie_temp)
    #affichage de la figure
    pyplot.show()


if __name__ == "__main__":
    #programme principal, en 3 étapes:
    #récupération de la météo en XML
    xml = recuperer_meteo(47.75,-3.36667,5)
    #récupération des dates et températures
    temp, dates = recuperer_serie(xml)
    #affichage des températures
    afficher_temp(temp, dates)

