"""
module de définition de la classe pendu
"""
#imports nécessaires au bon fonctionnement
from random import choice
from string import ascii_lowercase
#liste de mots; TODO: chargement les mots depuis un fichier ?
liste_mots = [
    "armoire",
    "boucle",
    "buisson",
    "bureau",
    "chaise",
    "carton",
    "couteau",
    "fichier",
    "garage",
    "glace",
    "journal",
    "kiwi",
    "lampe",
    "liste",
    "montagne",
    "remise",
    "sandale",
    "taxi",
    "vampire",
    "volant",
]
#création de la classe pour gérer le jeu
class Pendu:
    """
    classe pour gérer une partie de pendu
    """
    #constructeur: permettre la création d'une partie avec un nombre d'erreurs max
    def __init__(self, nb_erreurs_max:int)->None:
        """
        constructure du jeu
        En entrée:
        - nombre d'erreurs max, type int
        """
        #stockage de l'information via une propriété: elle devient accessible dans toutes les méthodes
        self.nb_erreurs_max = nb_erreurs_max

    def __afficher(self)->None:
        """
        méthode de l'affichage de l'état du jeu, à appeler dès que nécessaire
        """
        #affichage du mot en cours (reconstitution de la chaine à partir de la liste des lettres)
        print(self.mot_en_cours)
        #affichage des erreurs restantes
        print("Etats des erreurs : {}/{}".format(self.nb_erreur_utilisateur,
                                                 self.nb_erreurs_max))

    def lancer(self)->None:
        """
        Méthode pour lancer une nouvelle partie
        """
        #choix alétoire du mot dans la liste
        mot = choice(liste_mots)
        #création du mot secret, via une liste contenant autant de "_" que de lettre
        #rattachement à une propriété pour usage dans les autres méthodes
        self.mot_en_cours = list('_' * len(mot))
        #nombre d'erreurs effectuées
        self.nb_erreur_utilisateur = 0
        #la liste des lettres déjà saisies; 
        lettres_saisies = []
        #flag de fin de partie
        perdu = False
        gagne = False
        #tant que la partie n'est pas terminée
        while not perdu and not gagne:
            #saisie d'une lettre
            caractere = input("Merci de saisir une lettre: ")
            #contrôle de la saisie
            #premier cas, caractere n'est pas une lettre
            if caractere in lettres_saisies:
                #un souci...
                print("Retire tes moufles")
                #on ajouter une erreur
                self.nb_erreur_utilisateur = self.nb_erreur_utilisateur + 1
                print("Rappel des lettres: ".format(lettres_saisies))
            #second cas: trop de caractères saisis
            elif len(caractere) != 1:
                print('Trop de lettres')
            #second cas: caractère n'est pas une lettre
            elif caractere not in ascii_lowercase:
                print(f"{caractere} n'est pas une lettre !")
            #tout va bien, pas d'erreur de saisie !
            else:
                #on ajoute aux lettres déjà saisies
                lettres_saisies.append(caractere)
                #est ce lettre dans le mot ?
                if caractere in mot:
                    #oui... on cherche ses emplacements
                    for indice, lettre_mot in enumerate(mot):
                        #c'est une bonne place
                        if lettre_mot == caractere:
                            #on met à jour le mot à découvrir
                            self.mot_en_cours[indice] = caractere
                    print('Bonne pioche !')
                else:
                    #mauvais cas...
                    print('Mauvaise pioche')
                    #et on ajoute des erreurs !
                    self.nb_erreur_utilisateur = self.nb_erreur_utilisateur + 1 
                #affichage: on lui donne de la visibilité
                self.__afficher()
            #on vérifie les cas de fin de partie
            #nombre d'erreurs max atteint
            if self.nb_erreur_utilisateur>=self.nb_erreurs_max:
                perdu = True
                print('Perdu !')
            #ou mot trouvé !
            if '_' not in self.mot_en_cours:
                gagne = True
                print('Bravo !')

            

