"""
Module de définition de l'interface graphique tkinter pour le codage/décodage cesar
"""
#liste des imports nécessaires
from tkinter import Frame, Button, Entry, Text, END
from tkinter.filedialog import askopenfilename
from outils.cesar import coder_cesar, decoder_cesar
class CesarIHM:
    """
    Définition de la classe pour créer l'IHM
    """
    def __init__(self, fenetre):
        """
        Le constructeur. Il permet de déployer toute l'interface graphique
        En entrée: 
        - la fenêtre principale, type Tk
        Sortie:
        - None
        """
        #création d'une zone en haut, pour positionner correctement les boutons/entry VS la zone de texte
        zone_haut = Frame(fenetre)
        #affichage en mode pack
        zone_haut.pack()

        #création du bouton pour permettre de choisir le fichier à traiter
        b = Button(zone_haut, text="?", command=self.chercher)
        b.grid(row = 0, column=1)

        #création du bouton d'action, ici décoder
        d = Button(zone_haut, text="D", command=self.__decoder)
        d.grid(row = 1, column=1)

        #création de la zone de saisie pour l'utilisateur: ce sera le chemin choisi
        self.affichage_chemin = Entry(zone_haut)
        #passage en mode grid pour les widgets de cette frame
        self.affichage_chemin.grid(row = 0, column=0)

        #affichage d'une zone de texte pour l'affichage du texte traité
        self.zone_texte = Text(fenetre)
        self.zone_texte.pack()

    def __decoder(self):
        """
        Méthode pour décoder le fichier dont nous avons obtenu l'emplacement
        En entrée: 
        - self, l'IHM
        Sortie:
        - None
        """
        #depuis la zone de saisie, récupération du contenu, ie, l'emplacement
        chemin = self.affichage_chemin.get()
        #utilisation de la fonction décoder, et récupération du contenu traité
        message = decoder_cesar(chemin)
        #ajout dans la zone d'affichage
        self.zone_texte.insert(END, message)

    def chercher(self):
        """
        Méthode pour récupérer l'emplacement du fichier
        En entrée: 
        - self, l'IHM
        Sortie:
        - None
        """
        #interrogation de l'utilisateur: quel emplacement ?
        chemin = askopenfilename()
        #on ajoute cet emplacement dans la zone de saisie (avec nettoyage préalable)
        self.affichage_chemin.delete(0, END)
        self.affichage_chemin.insert(0, chemin)